/**
 *  @author Harshit Satya
 */

Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingAlumniMappedGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.resourcebookingalumnimappedgrid',
    store: 'facilitiesresources.resourcebooking.ResourceBookingAlumniMappedStore',
    title: getAlumni('MAPPED_ALUMNI'),
    selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
	},
	autoScroll: false,
	overflow: 'auto',
	cls:"alumniRSBMappingGridV3",
    //frame:true,
	border: true,
    refreshStoreData: true,
    isGridConfigurable: true, 
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,       
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'facilitiesresources.resourcebooking.ResourceBookingAlumniMappedStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true,
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnDelete',
		disabled:true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},'->'],
    columns: [{
        header: getAlumni('ALUMNI_ID'), //Alumni ID
        dataIndex: 'alumniUser',
        flex: .2
    },{
        header: getAlumni('NAME'), //Alumni Name
        dataIndex: 'alumniPrintName',
        flex: .2,
    },
    {
        header: getAlumni('ACADEMY_LOCATION'), //Alumni AcademyLocationName
        dataIndex: 'academyLocationName',
        flex: .2
    }, 
    {
        header: getAlumni('PROGRAM'), //Alumni Program
        dataIndex: 'programName',
        flex: .2
    },
    {
        header: getAlumni('BATCH'), //Alumni Batch
        dataIndex: 'batchName',
        flex: .2
    }]
});
