Ext.define('Academia.view.facilitiesresources.resourcemaster.EquipmentGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.equipmentgrid',
	title:getCommonTranslation('INTERNAL_INDEPENDENT_EQUIPMENTS'), //Internal Independent Equipments
	border: true,
//	autoScroll:true,
	store:'facilitiesresources.resourcebooking.EquipmentListStore',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	style:{
		marginTop:'16px !important',
		marginLeft:'19px !important',
		marginRight:'14px !important'
    },
	columns:[{
		header:getCommonTranslation('CODE'),
		dataIndex:'code',
		flex:0.5
	},{
		header:getCommonTranslation('NAME'),
		dataIndex:'name',
		flex:0.5,
		 renderer: function(v) {
             return v;
//			 return '<a href="' + v + '">' + v + '</a>';
         }
	},{
		header:getCommonTranslation('TYPE'),
		dataIndex:'type',
		flex:0.5
	},{
		header:getCommonTranslation('STATUS'),
		dataIndex:'status',
		flex:0.5,
		renderer: function(value) {
        	return getCommonTranslation(value);
        }
	}],
	tbar:[{
		xtype:'button',
		glyph: ICONGLYPH.ADDGLYPH,
		//text:getCommonTranslation('ADD_EQUIPMENT'),  //Add Equipment
		itemId: 'btnAdd',		
		tooltip: getCommonTranslation('ADD_EQUIPMENT')  //Add Equipment		
	},{
	    xtype: 'button',
	    tooltip: getCommonTranslation('EDIT'),  //Edit
	    itemId: 'btnEdit',
	    glyph: ICONGLYPH.EDITGLYPH
//	    text:getCommonTranslation('EDIT') //Edit
	},{
		xtype : 'button',
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),//View
		iconCls: 'view-icon'
//		text : getCommonTranslation('VIEW')  //View
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		tooltip :getCommonTranslation('DELETE'), //Delete
		cls: 'CustomToolbarBtnReject',
		glyph: ICONGLYPH.DELETEGLYPH 
//		text : getCommonTranslation('DELETE') //Delete
	},{
		xtype:'customcombobox',
		fieldLabel:getCommonTranslation('RESOURCE_TYPE'),
		store:'facilitiesresources.resourcebooking.ResourceTypeStore',
		displayField:'value',
		valueField:'id',
		itemId:'cmbResourceType',
		value:'',
		width:'25%',
		queryMode: 'local',
		triggerAcation:'all',
		fourceSelection:true
	},{
		xtype:'customcombobox',
		fieldLabel:getCommonTranslation('RESOURCE_STATUS'),
		store:'facilitiesresources.resourcemaster.ResourceStatusStore',
		valueField : 'value',
		displayField : 'name',
		value:'',
		labelWidth: 110,
		width:'25%',
		itemId:'cmbResourceStatus',
		queryMode: 'local',
		triggerAcation:'all',
		fourceSelection:true
	},{
		xtype: 'button',
		text : getCommonTranslation('RESET'),
		itemId : 'resetButtonItemId',
		buttonAlign : 'left',
//		ui : 'CustomBtnCancel',
		scale: CONSTANTS.BUTTONSIZE
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'facilitiesresources.resourcebooking.EquipmentListStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }]
});