Ext.define('Academia.view.facilitiesresources.resourcemaster.TemporyUnavailibilityForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.temproryunavailform',
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            vtype: 'daterange',
            name: 'fromDate',
            itemId: 'fromDate',
            endDateField: 'toDate',
            allowBlank: false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            fieldLabel: getCommonTranslation('FROM_DATE')
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDate',
            vtype: 'daterange',
            startDateField: 'fromDate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            fieldLabel: getCommonTranslation('TO_DATE'),
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        items: [{
	        xtype: 'radiogroup',
	        columns: 2,
	        width: '100%',
	        vertical: true,
	        items: [{
	            xtype: 'radio',
	            boxLabel: getCommonTranslation('COMPLETE_DAY'),
	            name: 'type',
	            checked: true,
	            inputValue: 'COMPLETE_DAY'
	        }, {
	            boxLabel: getCommonTranslation('SPECIFIC_TIMESLOT'),
	            name: 'type',
	            inputValue: 'SPECIFIC_TIMESLOT',
	            itemId: 'radioSpecificSlot'
	        }]
        }]
    }, {
        xtype: 'panel',
        itemId: 'timeSlotsPanel',
        hidden: true,
        margin: 0,
        //plugins: "formlabelrequired",
        items: []
    },  {
        xtype: 'fieldcontainer',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('REASON'),
            name: 'reason',
            store: 'facilitiesresources.resourcemaster.ReasonStore',
            displayField: 'value',
            valueField: 'id',
            itemId: 'reason',
            allowBlank: false,
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            itemId: 'btnSaveTempUnavailReason',
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});