/**
 * @author Ashutosh.Sharma
 */
Ext.define('Academia.view.facultyCourseInterest.ApproveWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.approvewindow',
	modal: true,
	autoScroll:true,
	title:getCommonTranslation('APPROVAL_COMMENT'),
	closeAction: 'destroy',
	items: [{
		xtype: 'form',
		defaults:{
			labelAlign:'top',
			autoScroll:false
		},
		standardSubmit: false,
		plugins:"formlabelrequired",    
		items:[{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{
					xtype: 'customcombobox',
					name: 'actionReason',
					itemId:'actionReasonId',
					fieldLabel: getCommonTranslation('ACTION_REASON'),
					store: 'lecturercostingdefinition.ActionReasonStore',
					valueField: 'id',
					displayField: 'code',
					typeAhead:true,
					forceSelection:true,
					allowBlank: false,
					width:460
				}]
		},{
			xtype: 'fieldcontainer',
			 layout: 'fit',
			 defaults: {
				 labelAlign: 'top'
			 },
			 height: 'auto',
			items:[{
				 xtype: 'textarea',
				 name: 'comments',
				 itemId:'comments',
				 fieldLabel: getCommonTranslation('COMMENTS'),
				 width:460,
				 maxLength:512,
				resizable: false,
				allowBlank: false,	
				 listeners:{
					 resize: function( ta, width, height, oldWidth, oldHeight, eOpts ){
						 try{
							 if(ta.getHeight() > 20){
								 var resizeHandlerDiv = Ext.query("#"+ta.id+"-rzwrap-rzproxy")[0];
								 ta.setHeight(resizeHandlerDiv.offsetHeight - 20);
							 }
						 }
						 catch(e){
							 //--
						 }
					 }
				 }
			 }]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action : 'Submit',
				formBind: true,
				text: getCommonTranslation('APPROVE'),
				itemId: 'approveSubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'CancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]

});
