/**
 *  @author Deepak.nigam
 */

var advanceFeeReportStore = 'feeandpayment.dashboardAndReports.AdvanceFeeReportStore';
Ext.define('Academia.view.feeandpayment.AdvanceFeeReportSponsorGrid', {
	//extend : 'Ext.grid.Panel',
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.advancefeereportsponsorgrid',
	store : advanceFeeReportStore,
	title: getCommonTranslation('LIST_OF_ADVANCE'),
	border: true,
	autoScroll: false,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	//Added For the Pagination
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : advanceFeeReportStore,
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
         var grid=this;                   
         grid.addExportToolBarItems(grid);
         this.callParent(arguments);     
  },
	tbar: [/*{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getFeeAndPaymentCommonTranslation('APPROVE'),
			itemId:'approveLink'	
		},{
			text:getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'),
			itemId:'doMappingLink'
		},{
			text:getFeeAndPaymentCommonTranslation('VIEW_UNMAPPED'),
			hidden:true,
			itemId:'viewUnmappedLink'
		},{
			text:getFeeAndPaymentCommonTranslation('VIEW_COVERAGE'),
			hidden:true,currencyId
			itemId:'viewCoverageLink'
		},{
			text:getCommonTranslation('UPLOAD_DOC'),
			itemId:'feePlanDoc'
		},{
			text:getFeeAndPaymentCommonTranslation('ASSOCIATE_STUDENT'),
			itemId:'associateStudentLink'
		}],
		 listeners: { click: function() { this.showMenu(); } }
	},'->',{
	        xtype: 'splitbutton',
	        itemId: 'exportToPdfBtn',
	        cls: 'CustomToolbarBtnExport',
	        iconCls:'export-pdf-icon',
	        menu: [{
	            text: 'Export Current Page',
	            itemId: 'exportCurrentPage'
	        }, {
	            text: 'Export All',
	            itemId: 'exportAll'
	        } ]
	    },{
	        xtype: 'splitbutton',
	        itemId: 'exportToXcelBtn',
	        cls: 'CustomToolbarBtnExport',
	        iconCls:'export-excel-icon',
	        //text: 'Export To Xcel',      
	        menu: [{
	            text: 'Export Current Page',
	            itemId: 'exportCurrentPage'
	        }, {
	            text: 'Export All',
	            itemId: 'exportAll'
	        } ]
	}*/],
	columns: [{
		header : getCommonTranslation('SPONSOR_Id'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getCommonTranslation('SPONSOR'),
		dataIndex : 'studentName',
		flex:1
	}/*{
		header : getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex : 'studentFirstName',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex : 'studentMiddleName',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'studentLastName',
		hidden: true,
		flex:1
	}*/,{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCommonTranslation('AMOUNT'),
		dataIndex : 'amount',
		flex : 1,
		renderer:function(value,meta,record){
			if(record.data.baseCurrencyId!=null && record.data.balanceAmountInALBaseCurrency!=null)
			{
				if(!isNullOrEmpty(value)) {
					return currencyRenderer(value,record.get("baseCurrencyId"));
				}
			}
			else
			{
				if(!isNullOrEmpty(value)) {
					return currencyRenderer(value,record.get("currencyId"));
				}
			}
		}
	}]
});
