/**
 *  @author Amlesh Kushwaha
 */
Ext.define('Academia.view.feeandpayment.BursaryMasterAccoutingGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.bursarymasteraccoutinggrid',
	store : 'feeandpayment.BursaryMasterAccoutingStore',
	/*cls:'feePlanRuleGridCls',*/
	border: true,
	//cls:'horizontal-scrolling-fix', 
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.BursaryMasterAccoutingStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled:true
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		disabled:true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		disabled:true
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('ACCOUNTING_YEAR'),
		dataIndex : 'accountingYear',
		flex : 1 
	},{
		header : getFeeAndPaymentCommonTranslation('TOTAL_BUDGET'),
		dataIndex : 'totalBudget',
		flex : 1	
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'balanceAmount',
		flex : 1	
	},{
		header : getFeeAndPaymentCommonTranslation('ACCOUNTING_TYPE'),
		dataIndex : 'basedType',
		flex : 1,
		renderer: function(value, metadata, record) {
			var val;
			if(value=="COST_CENTRE"){
				val ="Cost Centre Based";
			}else if(value=="DYNAMIC"){
				val ="Dynamic";
			}else if(value=="POET"){
				val ="POET Based";
			}
			return val;
		}
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHead',
		flex : 1 
	}]
});