/**
 *  @author Rajkumar.patidar
 */


Ext.define('Academia.view.feeandpayment.ManageFeeList', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managefeelist',
	store : 'feeandpayment.FeePlanListing',
	title: getCommonTranslation('LIST_OF_MANAGE_FEE_PLAN'),
	border: true,
	refreshStoreData:true,
	marginBottom:'10px',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.FeePlanListing',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	isGridConfigurable: true,
	enableColumnHide: false,
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getFeeAndPaymentCommonTranslation('APPROVE'),
			itemId:'approveLink'	
		},{
			text:getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'),
			itemId:'doMappingLink'
		},{
			text:getFeeAndPaymentCommonTranslation('VIEW_UNMAPPED'),
			hidden:true,
			itemId:'viewUnmappedLink'
		},{
			text:getFeeAndPaymentCommonTranslation('VIEW_COVERAGE'),
			hidden:true,
			itemId:'viewCoverageLink'
		},{
			text:getFeeAndPaymentCommonTranslation('PAYMENT_TERM_SETTINGS'),
			itemId:'feePlanDoc'
		},{
			text:getFeeAndPaymentCommonTranslation('ASSOCIATE_STUDENT'),
			itemId:'associateStudentLink'
		}],
		listeners: { click: function() { this.showMenu(); } }
	},'->',{
		xtype: 'button',
		itemId: 'exportFeePlanReportBtn',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
	},{
		xtype: 'button',
		itemId: 'btnPrint',
		hidden:false,
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('PRINT_RECORD')
	},],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('FEE_PLAN_ID'),
		dataIndex : 'feePlanId',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_PLAN_NAME'),
		dataIndex : 'feePlanName',
		flex:1
	},{
		header : getCommonTranslation('FEE_PLAN_TYPE'),
		dataIndex : 'feePlanType',
		flex:1
	},{
		header : getCommonTranslation('Valid_Till'),
		dataIndex : 'validTill',
		flex:1,
		hidden:true,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
	},{
		header : getCommonTranslation('APPROVAL_STATUS'),
		dataIndex : 'feePlanStatus',
		flex:1,
		renderer : function(value){
			if(value=='ACTIVE'){
				return getCommonTranslation('ACTIVE');
			}else if(value=='INACTIVE'){
				return getCommonTranslation('INACTIVE');
			}else if(value=='PENDING'){
				return getCommonTranslation('PENDING');
			}
		}
	},{
		header : getCommonTranslation('MAPPING_STATUS'),
		dataIndex : 'mappingStatus',
		flex:1,
		renderer : function(value){
			if(value=='MAPPED'){
				return getCommonTranslation('MAPPED');
			}else if(value=='UNMAPPED'){
				return getCommonTranslation('UNMAPPED');
			}
		}
	},{
		header : getCommonTranslation('NO_OF_DOCUMENT'),
		dataIndex : 'documentCount',
		flex : 1,
		hidden:true,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('FEE_PLAN_RULE'),
		dataIndex : 'feePlanRule',
		flex:1,
		sortable:true,
		renderer:function(){
			return "<a href='#'>View</a>";
		}
	},
	{
		header : getCommonTranslation('VALID_FROM'),
		dataIndex : 'validFrom',
		flex:1,
		hidden:true,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
	}]
});