/**
 * @author P Kumar
 */

Ext.define('Academia.view.feeandpayment.PaymentDoMappingWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.paymentdomappingwin',
	title:getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'),
	frame: true,
	autoScroll:true,
	modal:true,
	maxHeight: 600,
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'feeplandetailform',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'hidden',
			name:'paymentPlanId',
			itemId:'paymentPlanId'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'paymentPlan',
				itemId:'paymentPlan',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_ID'),
				allowBlank:true,
				readOnly:true
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype : 'customcombobox',
				name : 'academyLocation',
				itemId:'academyLocation',
				fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
				allowBlank: true,
				readOnly:true
			},{
				xtype: 'textfield',
				name: 'defaultPaymentPlan',
				itemId:'defaultPaymentPlanId',
				fieldLabel: getCommonTranslation('DEFAULT_PAYMENT_PLAN'),
				allowBlank:true,
				readOnly:true
			}]
		},{
			xtype: 'customcombobox',
			name: 'program',
			itemId:'program',
			width: 460,
			fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM'),
			allowBlank: true,
			readOnly:true
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'batch',
				itemId:'batch',
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				allowBlank: true,
				readOnly:true
			},{
				xtype: 'textfield',
				name: 'mappingStatus',
				itemId:'mappingStatus',
				readOnly:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('MAPPING_STATUS'),
				allowBlank:true
			}] 
		},{		
			xtype: 'textfield',
			width: 460,
			name: 'seatType',
			itemId:'seatType',
			fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			readOnly:true,
			allowBlank:true
		},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtn',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]	
});
