/**
 *  @author Amit G
 */

Ext.define('Academia.view.feeandpayment.ProjectedDiscountReportGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.projecteddiscountreportgrid',
	store : 'feeandpayment.FeeAndPaymentProjectedDiscountReportGridStore',
	title: getFeeAndPaymentCommonTranslation('LIST_OF_DISCOUNTS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'FeeProjectedDiscountReportStructure':1
        }
    },
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 features: [{
	        ftype: 'summary',
	        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.FeeAndPaymentProjectedDiscountReportGridStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
         var grid=this;                   
         grid.addExportToolBarItems(grid);
         this.callParent(arguments);     
  },
	tbar: [],
	columns: [{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1,
		summaryRenderer: function(value, summaryData, dataIndex) {
			if(portalId!=3){
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
	      }
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1,
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1,
	},{
		header : getCommonTranslation('DISCOUNT_FEE_HEAD'),
		dataIndex : 'feeHeadName',
		flex:1,
	},{
		header : getCommonTranslation('BILL_DATE'),
		dataIndex : 'billingDate',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		}
	},{
		header : getCommonTranslation('DISCOUNT_AMOUNT'),
		dataIndex : 'discountAmount',
		flex : 1.8,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("feeCurrencyId"));
			}
		}
	}]
});
