/**
 *  @author Rohit Thadani
 */


Ext.define('Academia.view.feeandpayment.ViewActualSponsorAccountStatementGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.viewactualsponsoraccountstatementgrid',
	store : 'feeandpayment.ViewActualAccountStatementGridStore',
	title: getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT'),
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	width:'100%',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
        ftype: 'summary',
        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
    }],
	tbar: ['->',{
		xtype: 'button',
		itemId: 'btnPrint',
		//icon: 'resources/images/print1.png',
		text:getCommonTranslation('EXPORTREPORTS')
	}],
	 initComponent: function() {
         var grid=this;                   
         grid.addExportToolBarItems(grid, false);
         this.callParent(arguments);     
  },
	columns: [{
		header : getFeeAndPaymentCommonTranslation('TRANSACTION_DATE'),
		dataIndex : 'transactionDate',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		},
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			  if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
				  return getFeeAndPaymentCommonTranslation('TOTAL')+" ("+store.data.items[0].data.baseCurrencyName+")";
			  } else {
				  return getFeeAndPaymentCommonTranslation('TOTAL');
			  }
		  }
	},{
		header : getFeeAndPaymentCommonTranslation('TRANSACTION_NUMBER'),
		dataIndex : 'transactionNo',
		flex:1,
		renderer:function(value,rec){
			//var id=rec.record.data.id;
			if(value!="" && value!=undefined && value != null){
				return '<a href="#">'+value+'</a>';
			}else{
				return "";
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('TRANSACTION_TYPE'),
		dataIndex : 'category',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		hidden: true,
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_NAME'),
		dataIndex : 'printName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('DESCRIPTION'),
		dataIndex : 'narration',
		flex:2
	},{
		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
		dataIndex : 'currencyExchangeRate',
		flex : 1,
	},{
		header : getFeeAndPaymentCommonTranslation('DEBIT'),
		dataIndex : 'debitAmount',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
				//return value;
			} else {
				return "";
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('CONVERTED_DEBIT_AMOUNT'),
		dataIndex : 'baseCurrencyDebitAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("baseCurrencyId"));
			} else {
				return "";
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('CREDIT'),
		dataIndex : 'creditAmount',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
				//return value;
			} else {
				return "";
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('CONVERTED_CREDIT_AMOUNT'),
		dataIndex : 'baseCurrencyCreditAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("baseCurrencyId"));
			} else {
				return "";
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE'),
		dataIndex : 'balanceAmount',
		flex:1,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				if(!isNullOrEmpty(record.data.debitCreditCode)){
					return currencyRenderer(value,record.get("currencyId"))+" "+record.data.debitCreditCode;
				} else {
					return currencyRenderer(value,record.get("currencyId"));
				}
			} else {
				return "";
			}
		},
        summaryRenderer: function(value, summaryData, dataIndex) {
        	if(!isNullOrEmpty(value)){
				
        		var store = this.getStore();
        		if(!isNullOrEmpty(store)){
        			var arrStoreItems = store.data.items;
                	var lastRecord = arrStoreItems[arrStoreItems.length-1];
                	if(!isNullOrEmpty(lastRecord)){
                		if(!isNullOrEmpty(lastRecord.data.debitCreditCode)){
                			return currencyRenderer(lastRecord.get("balanceAmount"),lastRecord.get("currencyId"))+" "+lastRecord.data.debitCreditCode;
                		} else {
                			return currencyRenderer(lastRecord.get("balanceAmount"),lastRecord.get("currencyId"));
                		}
                	} else {
                		return "";
                	}
        		}
			} else {
				return "";
			}
        }
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'baseCurrencyBalanceAmount',
		flex:1,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				if(!isNullOrEmpty(record.data.debitCreditCode)){
					return currencyRenderer(value,record.get("baseCurrencyId"))+" "+record.data.debitCreditCode;
				} else {
					return currencyRenderer(value,record.get("baseCurrencyId"));
				}
			} else {
				return "";
			}
		},
        summaryRenderer: function(value, summaryData, dataIndex) {
        	if(!isNullOrEmpty(value)){
				
        		var store = this.getStore();
        		if(!isNullOrEmpty(store)){
        			var arrStoreItems = store.data.items;
                	var lastRecord = arrStoreItems[arrStoreItems.length-1];
                	if(!isNullOrEmpty(lastRecord)){
                		if(!isNullOrEmpty(lastRecord.data.debitCreditCode)){
                			return currencyRenderer(lastRecord.get("baseCurrencyBalanceAmount"),lastRecord.get("baseCurrencyId"))+" "+lastRecord.data.debitCreditCode;
                		} else {
                			return currencyRenderer(lastRecord.get("baseCurrencyBalanceAmount"),lastRecord.get("baseCurrencyId"));
                		}
                	} else {
                		return "";
                	}
        		}
			} else {
				return "";
			}
        }
	}]
});
