/**
 *  @author swapnil.patil
 */


Ext.define('Academia.view.feeandpayment.ViewStudentAccountStatementGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.viewstudentaccountstatementgrid',
	store : 'feeandpayment.dashboardAndReports.ViewAccountStatementReportGrid',
	 title: getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT'),
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	width:'100%',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
        ftype: 'summary',
        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
    }],
	tbar: ['->',{
		xtype: 'button',
		itemId: 'btnPrint',
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('Print')
	}],
/*	 initComponent: function() {
         var grid=this;                   
         grid.addExportToolBarItems(grid);
         this.callParent(arguments);     
  },*/
	columns: [{
		header : getFeeAndPaymentCommonTranslation('DATE'),
		dataIndex : 'voucherDate',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		},
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.whetherDisplayTotal != false) {
				  return getFeeAndPaymentCommonTranslation('TOTAL');
			  }
	      }
	/*	summaryRenderer: function(value, summaryData, dataIndex) {
	          return getFeeAndPaymentCommonTranslation('TOTAL');
	      }*/
	},{
		header : getFeeAndPaymentCommonTranslation('VOUCHER_NUMBER'),
		dataIndex : 'voucherNo',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('VOUCHER_TYPE'),
		dataIndex : 'voucherType',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('LEDGER_NAME'),
		dataIndex : 'ledgerName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('PERTICULARS'),
		dataIndex : 'perticulars',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('DEBIT'),
		dataIndex : 'debit',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('CREDIT'),
		dataIndex : 'credit',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE'),
		dataIndex : 'balanceAmount',
		flex:1,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				var mssg;
				var balance=0;
				if(row > 0){
					balance = record.store.getAt(row-1).get('balanceAmount');
				}
				var debit = record.get('debit');
				var credit = record.get('credit');
				var totalAmunt =  parseInt(balance) + parseInt(debit) - parseInt(credit) ;
				record.set('balanceAmount',totalAmunt);
				
				if(totalAmunt>0){
					mssg = 'Dr';
				}else{
					mssg = 'Cr';
				}
				if(row<0){
					mssg='Dr';
				}
				return currencyRenderer(value,record.get("currencyId"))+' '+mssg;
			}
		},
		
		summaryRenderer:function(value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(value) && store.data.items[0].data.whetherDisplayTotal != false){
				var mssg;
				var balance=0;
				if(row > 0){
					balance = record.store.getAt(row-1).get('balanceAmount');
				}
				var debit = record.get('debit');
				var credit = record.get('credit');
				var totalAmunt =  parseInt(balance) + parseInt(debit) - parseInt(credit) ;
				record.set('balanceAmount',totalAmunt);
				
				if(totalAmunt>0){
					mssg = 'Dr';
				}else{
					mssg = 'Cr';
				}
				if(row<0){
					mssg='Dr';
				}
				return currencyRenderer(value,record.get("currencyId"))+' '+mssg;
			} else {
				return "";
			}
        }
		
	}]
});
