/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.feeandpayment.addsequence.ManageFineScheduleWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.managefineschedulewindow',
	modal: true,
	frame: true,
	resizable: false,
	autoScroll:true,
	height:400,
    width:810,
	title:getFeeAndPaymentCommonTranslation('MANAGE_FINE_SCHEDULE'),
	items: [{		
    xtype: 'form',
	autoScroll:false,
    
    defaults:{
    	labelAlign:'top',
    	width:226
    },
    standardSubmit: false,
    plugins:"formlabelrequired",    
    items:[
    	{
    		xtype: 'fieldcontainer',
    		defaults:{
    	    	labelAlign:'top',
    	    	width:220
    	    },
    		items:[
    			{
    		    	xtype: 'customcombobox',
    				name: 'copiedFeePlanRule',
    				itemId:'copiedFeePlanRuleId',
    				fieldLabel: getFeeAndPaymentCommonTranslation('LATE_FEE_HEAD'),
    				store: 'feeandpayment.LateFeeHeads',
    				valueField: 'id',
    				displayField: 'value',
    				allowBlank: false,
    				typeAhead:true,
    				forceSelection:true
    			},{
    				xtype:'panel',
    				itemId: 'fineSchedulePanel',
    				style:{margin:'0px'},
    				width: 950,
    				items:[{
    					xtype: 'fieldcontainer',
    					width: 950,
    					layout: {
    						type: 'hbox',
    						align: 'bottom'
    					},
    					items: [{
    						xtype:'datefield',
    						fieldLabel:getFeeAndPaymentCommonTranslation('FINE_FROM_DATE'),
    						itemId:'fineFromDate',
    						name:'fineFromDate',
    						labelAlign: 'top',
    						width: 220,
    					    allowBlank: false,
    						listeners: {
    							render: function(obj) {
    								obj = dateFormatRender(obj);						
   							}
    						},
							vtype: 'daterange',
							endDateField: 'fineToDate',
							editable:false,
    					},{
    						xtype:'datefield',
    						fieldLabel:getFeeAndPaymentCommonTranslation('FINE_TO_DATE'),
    						itemId:'fineToDate',
    						name:'fineToDate',
    						labelAlign: 'top',
    						width: 220,
    						allowBlank: false,
    						listeners: {
    							render: function(obj) {
    								obj = dateFormatRender(obj);						
    							}
    						},
							vtype: 'daterange',
							startDateField:'fineFromDate',
							editable:false,
    					},{
    						xtype: 'numberfield',
    						itemId: 'amount',
    						fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT'),
    						labelAlign: 'top',
    						width: 220,
    						name: 'amount',
    						minValue: 0,
    						maxLength:10,
    	                    allowBlank: false,
    			        	hideTrigger:true,
    			        	
    					},{
    						xtype: 'button',
    						itemId: 'btnAddFineSchedule',
    						cls: 'CustomBodyBtnSettings',
    						text: getCommonTranslation('ADDBUTTONTEXT'),
    						tooltip: getCommonTranslation('ADD')
    					}] 
    				}]
    			},
    		]
    	},
	{
		xtype: 'fieldcontainer',
		width:'100%',
		layout:'hbox',
		
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'btnSubmit',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		},{

			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'btnReset',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		
		},{
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			itemId: 'btnCancel',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
	}]
});
