/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.adjustment.ReceiptsList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.receiptslist',
	title : getFeeAndPaymentCommonTranslation('RECEIPTS'),
	store : 'feeandpayment.adjustment.ReceiptAdjustment',
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	tbar: [{
		xtype: 'button',
		itemId: 'nextBtn',
		disabled:true,
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		itemId: 'cancelSettlementLink',
		text:getFeeAndPaymentCommonTranslation('CANCEL_SETTLEMENT'),
		tooltip: getFeeAndPaymentCommonTranslation('CANCEL_SETTLEMENT')
	},'->',/*{

		xtype: 'splitbutton',
		itemId: 'exportToPdfBtn',
		cls: 'CustomToolbarBtnExport',
		iconCls:'export-pdf-icon',
		menu: [{
			text: 'Export Current Page',
			itemId: 'exportCurrentPage'
		}, {
			text: 'Export All',
			itemId: 'exportAll'
		} ]
	},*/{
		xtype: 'button',
		itemId: 'btnPrint',
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('PRINT_RECORD')
	}],
	dockedItems : [{/*
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.adjustment.ReceiptAdjustment',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	 */}],
	 columns: [{
		 header : getCommonTranslation('RECEIPT_NUMBER'),
		 dataIndex : 'receiptNo',
		 flex : 1	 
	 },{
		 header : getCommonTranslation('RECEIPT_DATE'),
		 dataIndex : 'transactionDate',
		 flex : 1,
		 renderer: function(date) {
			 return dateRender(date);
		 }
	 },{
		 header : getCommonTranslation('VOUCHER_MODE'),
		 dataIndex : 'voucherMode',
		 flex : 1	
	 },{
		 header : getCommonTranslation('NARRATION'),
		 dataIndex : 'narration',
		 hidden : false,
		 flex : 1	
	 },{
		 header : getCommonTranslation('RECEIPT_AMOUNT'),
		 dataIndex : 'amount',
		 flex : 1,
		 renderer:function(value,meta,record){
			 if(!isNullOrEmpty(value)) {
				 return currencyRenderer(value,record.get("currencyId"));
			 }                    
		 } 
	 },{
		 header : getCommonTranslation('ALREADY_ADJUSTED_AMOUNT'),
		 dataIndex : 'totalAdjustedAmount',
		 flex : 1,
		 renderer:function(value,meta,record){
			 if(!isNullOrEmpty(value)) {
				 return currencyRenderer(value,record.get("currencyId"));
			 }                    
		 } 
	 },{
		 header : getCommonTranslation('BALANCE_AMOUNT'),
		 dataIndex : 'totalBalanceAmount',
		 flex : 1,
		 renderer:function(value,meta,record){
			 if(!isNullOrEmpty(value)) {
				 return currencyRenderer(value,record.get("currencyId"));
			 }                    
		 } 
	 },{
		 header : getCommonTranslation('VIEW_ADJUSTMENTS'),
		 dataIndex : 'viewAdjustments',
		 flex : 1,
		 renderer:function(){
			 return  '<a href="#">View</a>';
		 }
	 }]
});