/**
 * @author dolly.khatri
 */
Ext.define('Academia.view.feeandpayment.coursefeedefinition.FeeSubHeadGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.feesubheadgridwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '40%',
	width: '80%',
	frame: true,
	title:getCommonTranslation('FEE_SUBHEADS'),
	items: [{
		xtype: 'grid',
		store : 'feeandpayment.coursefeedefinition.CourseFeeSubHeadStore',
		autoScroll: true,
		itemId : 'feesubheadgridwindowitemid',
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		 features: [{
		        ftype: 'summary',
		        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		    }],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'feeandpayment.coursefeedefinition.CourseFeeSubHeadStore',
				emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header:  getCommonTranslation('SERIAL_NO'),
			dataIndex: 'serialNo',
			flex:.1,
		    sortable: false,
		   
		},{
			header:  getCommonTranslation('SUB_HEAD'),
			dataIndex: 'feeHeadName',
			flex:.1,
		    sortable: false
		},{
			header:  getCommonTranslation('AMOUNT/WEIGHTAGE'),
			dataIndex: 'amountOrWeightage',
			flex:.1,
		    sortable: false
		},{
			header:  getCommonTranslation('COST_CENTER'),
			dataIndex: 'costCentre',
			flex:.1,
		    sortable: false
		},{
			header:  getCommonTranslation('REFUNDABLE'),
			dataIndex: 'isRefundable',
			flex:.1,
		    sortable: false,
		    renderer : function(value){
		    	if(value){
		    		return 'Yes';
		    	}
		    	else{
		    		return 'No';
		    	}
		    }
		   
		},{
			header:  getCommonTranslation('REFUND_RULE'),
			dataIndex: 'rulePrintName',
			flex:.1,
		    sortable: false,
		   
		},
		{
			header:  getCommonTranslation('DISCOUNT_RULE'),
			dataIndex: 'discountRulePrintName',
			flex:.1,
		    sortable: false,
		   
		}
		] 	

	}]
});

