/**
 * Bhanu PS
 */
var discountStatusStore = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"APPROVED", "name":getCommonTranslation('APPROVED')},
        {"value":"REJECTED", "name":getCommonTranslation('REJECTED')}] 
});
Ext.define('Academia.view.feeandpayment.discounts.DiscountApproveReject', {
	extend: 'Ext.window.Window',
	alias: 'widget.discountapprovereject',
	modal: true,
	autoScroll:true,
	//title: getFeeAndPaymentCommonTranslation('APPROVE_REJECT'),
	maxHeight:500,
	width: '40%',
	height:'55%',
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'discountapprovereject',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
			
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'vbox'
			},
			defaults :{
				width: 460
				//labelAlign:'top'
			},
			items: [{
				xtype:'displayfield',
				name:'noOfRecord',
				itemId:'noOfRecord',
				//labelAlign:'right',
				labelWidth:'60%',
				//column:1,
				fieldLabel:getExaminationTranslation('NO_OF_RECORD_SELECTED')
			},{
				xtype:'displayfield',
				name:'approved',
				itemId:'approvedId',
				labelWidth:'60%',
				style:'margin-top:-20px !important',
				hidden:true,
				fieldLabel:getFeeAndPaymentCommonTranslation('APPROVED_LABEL')
			},{
				xtype:'displayfield',
				name:'rejected',
				itemId:'rejectedId',
				labelWidth:'60%',
				style:'margin-top:-20px !important',
				hidden:true,
				fieldLabel:getFeeAndPaymentCommonTranslation('REJECTED_LABEL')
			},{
				xtype:'displayfield',
				name:'applied',
				itemId:'appliedId',
				labelWidth:'60%',
				style:'margin-top:-20px !important',
				hidden:true,
				fieldLabel:getFeeAndPaymentCommonTranslation('APPLIED_LABEL')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
	        	xtype: 'customcombobox',
	            name: 'appStatus',
	            itemId: 'appStatus',
	            //store:'feeandpayment.discount.DiscountStatusStore',
	            store:discountStatusStore,
	            allowBlank:false,
	            displayField:'name',
	            valueField:'value',
	            forceSelection:true,
	            typeAhead:true,
	            readOnly:true,
	            fieldLabel:getExaminationTranslation('STATUS')
	        },{
				xtype: 'datefield',
				name: 'approveRejectDate',
				itemId: 'approveRejectDateItemId',
				allowBlank:false,
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(field) {
						field = dateFormatRender(field);						
						field.setValue(new Date());
						//return dateFormatRender(field);
					}
				},
				//fieldLabel:getFeeAndPaymentCommonTranslation('APPROVE_REJECT_DATE') conditionaly managed from controller
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 460
			},
			items: [{
				xtype: 'textarea',
				name:'remark',
				itemId:'remarkItemId',
				width: 460,
				maxLength : 250,
				fieldLabel: getExaminationTranslation('REMARKS')
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SUBMIT'),
				itemId: 'submitButtonId',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]
});