/**
 *  @author Amit G
 */


Ext.define('Academia.view.feeandpayment.finance.ManageFinanceHoldGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managefinanceholdgrid',
	store : 'feeandpayment.finance.FinanceHoldGridDataListing',
	title: getCommonTranslation('LIST_OF_FINANCIAL_HOLD_TYPE'),
	border: true,
	refreshStoreData:true,
	frame:false,

	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.finance.FinanceHoldGridDataListing',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	isGridConfigurable: true,
	enableColumnHide: false,
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}/*,{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}*/,{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'applyToBtn',
		text:getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'),
		tooltip: getFeeAndPaymentCommonTranslation('APPLICABLE_FOR')
	}],
	columns: [{
		header : getCommonTranslation('FINANCE_HOLD_ID'),
		dataIndex : 'code',
		flex:1
	},{
		header : getCommonTranslation('FINANCE_HOLD_NAME'),
		dataIndex : 'name',
		flex:1
	},{
		header : getCommonTranslation('CUTOFF_DATE'),
		dataIndex : 'cutoffDate',
		flex:1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header : getCommonTranslation('APPLICABLE_ON'),
		dataIndex : 'financeApplicableOn',
		flex:1,
		renderer:function(value,meta,record){
			if(record.data.financeApplicableOn=='DUE_FEES_PERCENTAGE') {
				return 'Due Fees Percentage';
			} else {
				return 'Due Fees Amount';
			} 
		}
	},{
		header : getCommonTranslation('FINANCE_HOLD_TYPES'),
		dataIndex : 'financeHoldCount',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.financeHoldCount)) {
				if(record.data.financeHoldCount==0){
					return value;  
				} else {
					return '<a href=#>'+record.data.financeHoldCount+'</a>';
				}
			} else {
				return "-";   
			} 
		}
	},{
		header : getCommonTranslation('MAPPED_PROGRAMS'),
		dataIndex : 'mappedProgramCount',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.mappedProgramCount)) {
				if(record.data.mappedProgramCount==0){
					return value;  
				} else {
					return '<a href=#>'+record.data.mappedProgramCount+'</a>';
				}
			} else {
				return "-";   
			} 
		}
	},{
		header : getCommonTranslation('BLOCKED_STUDENTS'),
		dataIndex : 'blockedStudentCount',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.blockedStudentCount)) {
				if(record.data.blockedStudentCount==0){
					return value;  
				} else {
					return '<a href=#>'+record.data.blockedStudentCount+'</a>';
				}
			} else {
				return "-";   
			} 
		}
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'financeHoldStatus',
		flex:1,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
	}]
});