/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.finance.ManageFinanceHoldSearchForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.managefinanceholdsearchform',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	style:{'margin-left':'15px !important','width':'98%'},
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
			xtype:'hidden',
			name:'id'
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'financeHoldCodeName',
				fieldLabel: getFeeAndPaymentCommonTranslation('FINANCEHOLD_CODE_NAME'),
				itemId:'financeHoldCodeName',
				store: 'feeandpayment.finance.FinanceHoldIdNameStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'status',
				fieldLabel: getFeeAndPaymentCommonTranslation('STATUS'),
				itemId:'status',
				store: 'feeandpayment.finance.FinanceHoldStatusStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel: getFeeAndPaymentCommonTranslation('CUTOFF_DATE'),
				name : 'cutOffDate',
				itemId : 'cutOffDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			},{  
				xtype: 'customcombobox',
				name: 'holdType',
				itemId:'holdType',
				fieldLabel: getFeeAndPaymentCommonTranslation('HOLD_TYPE'),
				//store: 'feeandpayment.finance.FinanceHoldTypeStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.feeandpayment.finance.FinanceHoldTypeStore');
						combo.bindStore(store)
					}
				}
			}]	
		},{
			xtype: 'panel',
			style:{marginLeft:'-12px',marginBottom:'-5px'},
			width: 'auto',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	});
