/**
 */

Ext.define('Academia.view.feeandpayment.managebill.ChangeBillDueDateWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.changebillduedatewin',
	title: getFeeAndPaymentCommonTranslation('Change_Bill_Due_Date'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'ChangeBillDueDateWin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype:'fieldcontainer',
			layout:'vbox',
			width: '100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
		items: [{
			xtype: 'displayfield',
			labelAlign: 'left',
			name: 'totalRecord',
			readOnly:true,
			itemId:'totalRecordId',
			fieldLabel: getCommonTranslation("TOTAL_RECORDS")
		},
			{
			xtype: 'datefield',
			name: 'changeBillDueDateId',
			itemId:'changeBillDueDateId',
			minValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			editable:false,
			fieldLabel: getCommonTranslation('SELECT_DATE')
		}]
		},
		
		{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtnChangedueDate',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtnCandidate',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});