/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.feeandpayment.payment.DebitOrderChangeStatusWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.debitorderchangestatuswin',
	title: getFeeAndPaymentCommonTranslation('CHANGE_STATUS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'debitorderchangestatuswin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226,
		},
		standardSubmit: false,
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'debitOrderStatus',
				itemId:'debitOrderStatus',
				fieldLabel: getFeeAndPaymentCommonTranslation('DEBIT_ORDER_STATUS'),
				allowBlank: false,
				value : 'Processed',
				readOnly: true,
			},{
	        	xtype: 'datefield',
	        	fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_DATE'),
	        	name: 'receiptDate',
	        	itemId: 'receiptDate',
	        	hideTrigger:true,
	        	readOnly: true,
	        	allowBlank: false,
	        	listeners: {
	        		render: function(field) {
	        			field = dateFormatRender(field);						
	        			field.setValue(Ext.Date.add(new Date()));
	        		},
	        		focus: function(obj) {
        				obj.getPicker().hide();
        			}
	        	},
	        }]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'costCentre',
				itemId:'costCentre',
				fieldLabel: getFeeAndPaymentCommonTranslation('COST_CENTRE'),
				store: 'feeandpayment.receipts.CostCentreReceipt',
				valueField: 'id',
				displayField: 'value',
				forceSelection: true,
				editable: false,
			},{
				xtype: 'customcombobox',
				name: 'receivingCurrency',
				itemId:'receivingCurrency',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIVING_CURRENCY'),
				store:'feeandpayment.AcademyCurrency',
				valueField: 'id',
				displayField: 'name',
				allowBlank:false,
				forceSelection: true,
				editable: false,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'externalReceiptNum',
				itemId:'externalReceiptNum',
				maskRe: /[A-Za-z0-9\s]/,
				fieldLabel: getFeeAndPaymentCommonTranslation('EXTERNAL_RECEIPT_NO'),
				maxLength: 100
			}]
		},{
			xtype:'fieldcontainer',
			layout:'vbox',
			width: 'auto',
			defaults: {
				width: 464,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textarea',
				name: 'narration',
				itemId:'narration',
				fieldLabel: getFeeAndPaymentCommonTranslation('NARRATION'),
				allowBlank:false
			},{
				xtype: 'radiogroup',
				itemId:'isAutoSettlement',
				labelAlign:'top',
				name:'isAutoSettlement',
				fieldLabel: getFeeAndPaymentCommonTranslation('AUTO_SETTLEMENT'),
				vertical: false,
				layout: {
					type: 'hbox'
				},
				items: [{
					boxLabel: getFeeAndPaymentCommonTranslation('YES'),
					name: 'isAutoSettlement',
					itemId: 'isAutoSettlementYes',
					inputValue: true,
				}, {
					boxLabel: getFeeAndPaymentCommonTranslation('No'),
					name: 'isAutoSettlement',
					itemId: 'isAutoSettlementNo',
					inputValue: false,
					checked: true
				}]

			}]
		},{
				xtype:'fieldcontainer',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'SubmitBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtn',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
	}]
});