/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.feeandpayment.payment.ManageDebitOrdersGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.managedebitordersgrid',
	store: 'feeandpayment.payment.ManageDebitOrderGridStore',
	title: getFeeAndPaymentCommonTranslation("MANAGE_DEBIT_ORDERS"),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
    enableColumnHide: false,
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.payment.ManageDebitOrderGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'changeStatus',
		tooltip: getFeeAndPaymentCommonTranslation('CHANGE_STATUS'),
		text: getFeeAndPaymentCommonTranslation('CHANGE_STATUS'),
		disabled:true
     },'->',{
		xtype: 'button',
		itemId: 'exportReport',
		tooltip : getPersonModuleTranslation('EXPORT_REPORTS'),
		text : getPersonModuleTranslation('EXPORT_REPORTS'),
		disabled:true
	}],
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	columns: [{
		header:  getCommonTranslation("STUDENT_ID"),
		dataIndex:'studentId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("STUDENT_NAME"),
		dataIndex:'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("PROGRAM"),
		dataIndex:'program',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("BATCH"),
		dataIndex:'batch',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("SEAT_TYPE"),
		dataIndex:'seatType',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("PAYMENT_PLAN"),
		dataIndex:'paymentPlan',
		flex:.1,
		sortable:true
	},{
		header:  getPersonModuleTranslation("INSTALMENT_ID"),
		dataIndex:'instalmentId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("AMOUNT"),
		dataIndex:'amount',
		flex:.1,
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                      
		} 
	},{
		header:  getPersonModuleTranslation("FPD_DEBIT_ORDER_DATE"),
		dataIndex:'debitOrderDate',
		flex:.1,
		sortable:true
	},{
		header:  getPersonModuleTranslation("PAYMENT_DATE"),
		dataIndex:'paymentDate',
		flex:.1,
		sortable:true
	},{
		header:  getPersonModuleTranslation("ACCOUNT_NO"),
		dataIndex:'accountNo',
		flex:.1,
		sortable:true
	},{
		header:  getPersonModuleTranslation("FPD_ACCOUNT_NAME"),
		dataIndex:'accountName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("BRANCH_NAME"),
		dataIndex:'branchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("BRANCH_CODE"),
		dataIndex:'branchCode',
		flex:.1,
		sortable:true
	},{
		header:  getPersonModuleTranslation("DEBIT_ORDER_STATUS"),
		dataIndex: 'debitOrderStatus',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			var val;
			if(value=='PENDING'){
				val =getCommonTranslation("PENDING");
			}else if(value=='PROCESSED'){
				val =getCommonTranslation("PROCESSED");
			}
			return val;
		}
	},{
		header:  getCommonTranslation("RECEIPT_NUMBER"),
		dataIndex:'receiptNo',
		flex:.1,
		sortable:true
	}]
});
