/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.payment.PaymentListForDependedFeeHead', {
	//extend : 'Ext.grid.Panel',
	alias : 'widget.paymentlistfordependedfeehead',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	store : 'feeandpayment.payment.PaymentForDependedFeeHead',
	title: getCommonTranslation('LIST_OF_PAYMENT'),
	border: true,
	//autoScroll: true,
	style: {overflowX: 'auto', overflowY: 'hidden'},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
        ftype: 'summary',
        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW  
    }],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.payment.PaymentForDependedFeeHead',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
	        var grid=this;                   
	        grid.addExportToolBarItems(grid);
	        this.callParent(arguments);     
	 },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('CANCEL'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex : 1,
		summaryRenderer: function(value, summaryData, dataIndex) {
	          return getFeeAndPaymentCommonTranslation('TOTAL');
	      }
	},{
		header : getFeeAndPaymentCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'programPrintName',
		flex : 1,
		hidden : true
	},{
		header : getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		hidden : true
	},{
		header : getFeeAndPaymentCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1,
		hidden : true
	},{
		header : getFeeAndPaymentCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex : 1,
		hidden : true
	},{
		header : getFeeAndPaymentCommonTranslation('THIRD_PARTY_CODE'),
		dataIndex : 'feeThirdPartiescode',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('THIRD_PARTY_NAME'),
		dataIndex : 'feeThirdpartiesprintName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('PAYMENT_VOUCHER_NO'),
		dataIndex : 'paymentVoucherNo',
		flex : 1
	},{
    	 header : getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
     	 dataIndex : 'voucherMode',
     	 flex : 1,
     	 renderer:function(value){
  			if(value==getFeeAndPaymentCommonTranslation('CASH')){
  				return getCommonTranslation('CASH');
  			}else if(value==getFeeAndPaymentCommonTranslation('BANK')){
  				return getCommonTranslation('BANK');
  			}
  		}
	},{
		header : getFeeAndPaymentCommonTranslation('SETTLEMENT_STATUS'),
		dataIndex : 'paymentStatus',
		flex : 1,
		 renderer:function(value){
				if(value==getFeeAndPaymentCommonTranslation('REVERSED')){
					return getCommonTranslation('REVERSED');
				}else if(value==getFeeAndPaymentCommonTranslation('SETTLED')){
					return getCommonTranslation('SETTLED');
				}else if(value==getFeeAndPaymentCommonTranslation('PARTLY_SETTLED')){
					return getCommonTranslation('PARTLY_SETTLED');
				}else if(value==getFeeAndPaymentCommonTranslation('FULLY_PENDING')){
					return getCommonTranslation('FULLY_PENDING');
				}else if(value==getFeeAndPaymentCommonTranslation('CANCELLED')){
					return getCommonTranslation('CANCELLED');
				}
			}
     },{
    	 header : getFeeAndPaymentCommonTranslation('PAYMENT_AMOUNT'),
     	 dataIndex : 'amount',
     	 flex : 1,
     	align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}
     },{

 		header : getFeeAndPaymentCommonTranslation('CURRENCY_EXCHANGE_RATE'),
 		dataIndex : 'currencyExchangeRate',
 		flex : 1.2,
 		
   },{
    	 header : getFeeAndPaymentCommonTranslation('CONVERTED_AMOUNT'),
  		dataIndex : 'convertedAmount',
  		flex : 1.2,
    },{
    	 header : getFeeAndPaymentCommonTranslation('PAYMENT_DATE'),
     	 dataIndex : 'transactionDate',
     	 flex : 1,
     	 renderer:function(val){		
			return dateRender(val);
		 }
     },{
    	 header : getFeeAndPaymentCommonTranslation('ADJUSTMENT_DETAILS'),
     	 dataIndex : 'adjustmentDetails',
     	 flex : 1,
     	renderer : function(value){
			  return  '<a href="#">'+"View"+'</a>';
		}
     },{
    	 header : getFeeAndPaymentCommonTranslation('INSTRUMENT_DETAILS'),
     	 dataIndex : 'instrumentDetails',
     	 flex : 1,
     	 renderer : function(value, metaData, record, row, col, store, gridView){
     	 if(record.data.voucherMode==getFeeAndPaymentCommonTranslation('BANK')){
			  return  '<a href="#">'+"View"+'</a>';
   		 }else{
   			return value;
   		}}
     }]
});