/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.payment.PaymentSearchForm',{
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.paymentsearchform',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	defaults: {
		labelAlign: 'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'multiselectcombofield',
            name: 'fnpMultiBrandCampusNamePayment',
            itemId: 'fnpMultiBrandCampusPaymentItemId',
            fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
            valueField: 'id',
			displayField: 'value',
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
  			width: 698,
  			height:58,
  			cls:'multiBrandCampusCls',
  			style :{
  				marginLeft: '6px'
  			},
  			matchFieldWidth:true,
  			maxLength:15000,
  			typeAhead: true,
            allowBlank:false,
            forceSelection: true,
            autoloadStore: false,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'billType',
			itemId:'billType',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_TYPE'),
			store:Ext.create('Academia.store.feeandpayment.managebill.BillType'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'billFor',
			itemId:'billFor',
			fieldLabel: getCommonTranslation('PAYMENT_VIEW1'),
			store: Ext.create ('Academia.store.feeandpayment.managebill.BillForPayment'),//'feeandpayment.managebill.BillFor',
			valueField: 'id',
			//displayField: 'value',
			displayField: 'code',
			queryMode: 'local',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'thirdParty',
			itemId:'thirdParty',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('THIRD_PARTIES'),
			store: 'feeandpayment.managebill.ThirdParties',
			valueField: 'id',
			displayField: 'firstName',
			queryParam:'codeOrPrintName',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			//minChars:3,
			typeAhead:false,
			forceSelection:true,
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{firstName} {lastName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'sponsors',
			itemId:'sponsors',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('SPONSOR'),
			store: 'feeandpayment.managebill.Sponsors',
			valueField: 'id',
			displayField: 'sponsorName',
			queryParam:'sponsorNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{sponsorshipCode}/{sponsorName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'applicant',
			itemId:'applicant',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT'),
			store: 'feeandpayment.managebill.Applicant',
			valueField: 'id',
			displayField: 'printName',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'user',
			itemId:'userId',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('USER'),
			store: 'feeandpayment.managebill.User',
			valueField: 'id',
			displayField: 'nameToBePrinted',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{nameToBePrinted}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'vbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'scholarship',
			itemId:'scholarship',
			hidden:true,
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('SCHOLARSHIP'),
			store: 'feeandpayment.managebill.ScholarshipSmartSearch',
			valueField: 'id',
			displayField: 'scholarshipName',
			queryParam:'scholarshipNameOrCode',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			//minChars:3,
			allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{scholarshipCode}/{scholarshipName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'scholarshipStudent',
			itemId:'scholarshipStudent',
			hidden:true,
			disabled:true,
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.managebill.ScholarshipStudent'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			//allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'paymentCurrency',
			itemId:'paymentCurrency',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_CURRENCY'),
			store:'feeandpayment.FeeCurrencyStore',
			valueField: 'id',
			displayField: 'name',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'paymentMode',
			itemId:'paymentMode',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
			store:'feeandpayment.FeePaymentMode',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true 
		},{
			xtype: 'customcombobox',
			name: 'paymentStatus',
			itemId:'paymentStatus',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_STATUS'),
			store:'feeandpayment.payment.PaymentStatus',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		}]
	},{ 
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'voucherMode',
			itemId:'voucherMode',
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
			store:'feeandpayment.payment.VoucherMode',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'generationType',
			itemId:'generationType',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_GENERATION_TYPE'),
			store:'feeandpayment.receipts.BillGenerationType',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'paymentVoucherNo',
			itemId:'paymentVoucherNo',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_VOUCHER_NO'),
			store: 'feeandpayment.payment.PaymentVoucherNo',
			valueField: 'id',
			displayField: 'value',
			queryParam:'paymentVoucherNo',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{ 
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			labelAlign: 'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'billNo',
			itemId:'billNo',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_NO'),
			store: 'feeandpayment.managebill.DependentBillId',
			valueField: 'id',
			displayField: 'value',
			queryParam:'billNo',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{ 
		xtype:'fieldset',
		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		width:'100%',
		defaults: {
			labelAlign: 'top',
			width:226
		},
		style: {
        	 marginTop: '40px!important'
       },
		items:[{
			xtype: 'multiselectcombofield',
			name: 'program',
			style:{marginTop:'10px'},
			width: 460,
			itemId: 'program',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			//store:'program.ProgramGroupStore',
			store:'common.ProgramByAcademyLocationStore',
			displayField:'valueCode',
			valueField:'id',
			typeAhead:true,
			autoloadStore: false,
			forceSelection:true,
			cls:'receiptHeaderMultiselect',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
			//maxLength:2000
		},{ 
			xtype: 'multiselectcombofield',
			name: 'batch',
			width: 460,
			itemId: 'batch',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			store: 'program.programbatchdetail.BatchStore',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			autoloadStore: false,
			disabled:true,
			forceSelection:true,
			maxLength:2000,
			cls:'receiptHeaderMultiselect'
		},{
			xtype: 'multiselectcombofield',
			name: 'section',
			autoloadStore: false,
			width: 460,
			itemId: 'section',
			fieldLabel: getCourseTxCommonTranslation('SECTION'),
			store:'coursetransaction.sectionmanagement.SectionMultiSelect',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			disabled:true,
			forceSelection:true,
			maxLength:2000,
			cls:'receiptHeaderMultiselect'
		},/*{ 
				xtype:'fieldcontainer',
				layout:'hbox',
				width:'100%',
				defaults: {
					labelAlign: 'top',
					width:226
				},
				items:[{
					xtype: 'customcombobox',
					name: 'feePlanType',
					itemId:'feePlanType',
					fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
					store:'feeandpayment.FeePlanTypeStore',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				},{
					xtype: 'customcombobox',
					name: 'feePlan',
					itemId:'feePlan',
					fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN'),
					store:'feeandpayment.FeePlan',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				},{
					xtype: 'customcombobox',
					name: 'feeHead',
					itemId:'feeHead',
					fieldLabel: getFeeAndPaymentCommonTranslation('FEE_HEAD'),
					store:'feeandpayment.FeeHeads',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				}]
			},*/
		{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'billStatus',
				itemId:'billStatus',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_STATUS'),
				store:'feeandpayment.managebill.BillStatus',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'datefield',
				name: 'billDateFrom',
				itemId:'billDateFrom',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				editable:false,
				vtype: 'daterange',
  				endDateField: 'billDateTill',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE_FROM')
			},{
				xtype: 'datefield',
				name: 'billDateTill',
				itemId:'billDateTill',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT,
  				vtype: 'daterange',
				startDateField: 'billDateFrom',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE_TILL')
			}]},
			{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items:[{
				xtype: 'datefield',
				name: 'billDueDateFrom',
				itemId:'billDueDateFrom',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				editable:false,
				vtype: 'daterange',
				endDateField: 'billDueDateTill',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DUE_DATE_FROM')
			},{
				xtype: 'datefield',
				name: 'billDueDateTill',
				itemId:'billDueDateTill',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT,
				editable:false,
				vtype: 'daterange',
				startDateField: 'billDueDateFrom',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DUE_DATE_TILL')
			},{
				xtype: 'datefield',
				name: 'paymentDateFrom',
				itemId:'paymentDateFrom',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				editable:false,
				vtype: 'daterange',
				endDateField: 'paymentDateTo',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_DATE_FROM')
			}]
			},{ 
				xtype:'fieldcontainer',
				layout:'hbox',
				width:'100%',
				defaults: {
					labelAlign: 'top',
					width:226
				},
          items:[{xtype: 'datefield',
			name: 'paymentDateTo',
			itemId:'paymentDateTo',
			listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
              
            //--submitFormat: CONSTANTS.DATE_FORMAT,
			editable:false,
			vtype: 'daterange',
			startDateField: 'paymentDateFrom',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_DATE_TO')
		},
		{
			xtype: 'multiselectcombofield',
			name: 'costCentre',
			itemId:'costCentre',
			fieldLabel: getFeeAndPaymentCommonTranslation('COST_CENTER'),
			store: 'feeandpayment.receipts.CostCentreReceipt',
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			hidden : false,
			maxLength:2000,
			cls:'receiptHeaderMultiselect'
		}]
			},{ 
				xtype: 'fieldcontainer',
                width: '100%',
                layout: 'vbox', // Ensures elements are stacked vertically
          items: [
        {
            xtype: 'checkboxfield',
            width: 226,
            style: {
                marginTop: '10px' // Adjust margin for better alignment
            },
            itemId: 'inactiveStudentItemId',
            boxLabel: getFeeAndPaymentCommonTranslation('INACTIVE_STUDENTS'),
            name: 'inactiveStudents',
            inputValue: true,
			uncheckedValue: false

        }
    ]
},],
		listeners:{
			render: function(myfieldset){
				myfieldset.setMargin('-10px');
			}
		}
			
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind: true,
			 margin:'0 0 0 0',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
