/**
 * @author Priyanshi Sharma 
 */

 
Ext.define('Academia.view.feeandpayment.payment.ReceiptAndPaymentViewAdjustmentWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.receiptandpaymentviewadjustmentwindow',
	modal : true,
	autoScroll: true,
	height: '50%',
	width: '80%',
	defaults:{
		width:'100%'
	},
	layout:'vbox',
	frame: true,
	title:getFeeAndPaymentCommonTranslation('ADJUSTMENTS_DETAILS'),
	items: [{
		xtype: 'grid',
		itemId:'paymentViewGrid',
		store : 'feeandpayment.adjustment.ReceiptPaymentViewAdjustmentStore',
		autoScroll: true,
		border:true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'feeandpayment.adjustment.ReceiptPaymentViewAdjustmentStore',
				emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
			dataIndex : 'receiptNo',
			flex : 1	 
		},{
			header : getFeeAndPaymentCommonTranslation('FEE_ADJUSTED_AMOUNT'),
			dataIndex : 'feeAdjustedAmount',
			flex : 1,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return currencyRenderer(value,record.get("currencyId"));
				}                    
			} 
		} ,{
			header : getFeeAndPaymentCommonTranslation('ADJUSTMENT_DATE'),
			dataIndex : 'adjustmentDate',
			flex : 1,
			renderer: function(date) {
				return dateRender(date);
			}
		},{
			header : getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
			dataIndex : 'voucherMode',
			flex : 1,
			hidden:true,
			renderer:function(value){
				if(!isNullOrEmpty(value)){
					return getCommonTranslation(value);
				}
			}
		},{
			header : getFeeAndPaymentCommonTranslation('VOUCHER_TYPE'),
			dataIndex : 'voucherType',
			hidden:true,
			flex : 1,renderer:function(value){
				if(!isNullOrEmpty(value)){
					return getCommonTranslation(value);
				}
			}
		},{
			header : getFeeAndPaymentCommonTranslation('RECEIPT_DATE'),
			dataIndex : 'receiptDate',
			flex : 1,
			renderer: function(date) {
				return dateRender(date);
			}
		}] 	

	}]
});
