Ext.define('Academia.view.feeandpayment.paymentPlanEnrollment.VWPaymentPlanEnrollmentGrid',
	{
		extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
		alias : 'widget.vwpaymentplanenrollmentgrid',
		store : 'feeandpayment.paymentPlanEnrollment.StoFnpPaymentPlanStudentEnrollStore',
		title : getFeeAndPaymentCommonTranslation('LIST_OF_REQUESTS_RECEIVED'),
		selType : 'checkboxmodel',
		itemId : 'PBSCourseEnrollmentGridItemId',
		refreshStoreData:true,
		/*headerFix:{
			headerFix: true,
			portalIdsWithStructure: {
				'stcfnppaymentplanenrollmentstructure':1
			}
		},*/
		selModel : {
			mode:'MULTI',
			showHeaderCheckbox: true,
			allowDeselect: true,
			checkOnly : true,
			renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {	
				if(record.data.status == "WAITING_FOR_APPROVAL"){
					var baseCSSPrefix = Ext.baseCSSPrefix;
					metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
					return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
					
				}
				else{
					value = '<input type = "checkbox" checked disabled = true style = "margin-left: -3px;"/>';
					return value;
				}
			}
		},
		border : true,
		autoScroll : true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		initComponent : function() {
			var grid = this;
			grid.addExportToolBarItems(grid);
			this.callParent(arguments);
		},
		tbar : [
				{
					xtype: 'displayfield',
					name: 'enrollmentStatusMassage',
					itemId:'enrollmentStatusMassage',
				}],
		columns : [
			{
				header : getCommonTranslation('STUDENT_ID'),
				dataIndex : 'studentId',
				flex : .1,
				hidden:true
			},{
			header : getCommonTranslation('STUDENT_CODE'),
			dataIndex : 'studentCode',
			sortable : true,
			flex : .1
		}, {
			header : getCommonTranslation('ADMISSION_CODE'),
			dataIndex : 'admissionCode',
			sortable : true,
			flex : .1
		}, {
			header : getCommonTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex : .1
		}, {
			header : getFeeAndPaymentCommonTranslation('STATUS'),
			dataIndex : 'status',
			flex : .1,
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				if(val == 'STUDENT_ENROLLED'){
					return 'Auto-enrolled'
				}
				else if(val == "ENROLLED"){
					return 'Admin Enrolled'
				}
				else if(val =="WAITING_FOR_APPROVAL"){
					return 'Requested';
				}
				else if(val =="APPROVED"){
					return 'Approved';
				}
				else if(val =="REJECTED"){
					return 'Rejected';
				}
				else{
					return val; 
				}
			}
			
		}]
	});