/**
 * @author Deepak Nigam
 */
var applicantOutstandingStore='feeandpayment.reports.ApplicantOutstandingReportStore';
Ext.define('Academia.view.feeandpayment.reports.ApplicantOutstandingReportGrid',{
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.applicantoutstandingreportgrid',
	store:applicantOutstandingStore,
	title: getCommonTranslation('APPLICANT_OUTSTANDING_REPORT'),
	cls:'centerAlignTitle',
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : applicantOutstandingStore,
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns:[{
		header : getCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex:1,
		/*summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}*/
		summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
			if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
			// a = currencyRenderer('',store.data.items[0].data.acadLocBaseCurrencyId).split(" ");
				return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
			}
			else {
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
		}
	},{
		header : getCommonTranslation('BILL_DATE'),
		dataIndex : 'billingDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('DUE_DATE'),
		dataIndex : 'dueDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
		/*},{
		header : getFeeAndPaymentCommonTranslation('DUE_DAYS'),
		dataIndex : 'dueDays',
		flex:1*/
	},{
		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
		dataIndex : 'currencyExchangeRate',
		flex:1.0,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		/*renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},*/
	},{
		header : getCommonTranslation('BILL_AMOUNT'),
		dataIndex : 'billAmount',
		flex:1.0,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'EX'){
				return currencyRenderer(value, store.data.items[0].data.currencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('CONVERTED_INVOICE_AMOUNT'),
		dataIndex : 'convertedInvoiceAmount',
		flex:1.0,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
				return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('OUTSTANDING_AMOUNT'),
		dataIndex : 'outstandingAmount',
		flex:1.8,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'EX'){
				return currencyRenderer(value, store.data.items[0].data.currencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('CONVERTED_OUTSTANDING_AMOUNT'),
		dataIndex : 'convertedOutstandingAmount',
		flex:1.0,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
				return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
			}
			else {
				return '';
			}
		}
	},{
		header:getCommonTranslation('TOTAL_AMOUNT'),
		dataIndex:'totalBillAmount',
		flex : 1,
		hidden: true,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'EX'){
				return currencyRenderer(value, store.data.items[0].data.currencyId);
			}
			else {
				return '';
			}
		}
	},{
		header:getCommonTranslation('DISCOUNT_AMOUNT'),
		dataIndex:'discountAmount',
		flex : 1,
		hidden: true,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'EX'){
				return currencyRenderer(value, store.data.items[0].data.currencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('APPLICANT_ID'),
		dataIndex : 'applicationCode',
		flex:1,
		sortable:true,
		renderer:function(value){
			return '<a href=#>'+value+'</a>'
		}
	},{
		header : getCommonTranslation('APPLICANT_NAME'),
		dataIndex : 'printName',
		flex:1
	},{
		header : getCommonTranslation('FATHER_NAME'),
		dataIndex : 'fatherName',
		flex:1,
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1,
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1,
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatName',
		flex:1,
	},{
		header : getCommonTranslation('BILL_STATUS'),
		dataIndex : 'billingStatus',
		flex:1,
		renderer:function(value){
			return getCommonTranslation(value);
		}
	},{
		header : getCommonTranslation('ADDRESS'),
		dataIndex : 'address',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('EMAIL_ID'),
		dataIndex : 'emailId',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('MOBILE_NUMBER'),
		dataIndex : 'mobileNo',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'personFirstName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'personMiddleName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'personLastName',
		flex:1,
		hidden:true
	}
	]

});
