/**
 * @author Ranga

 */
var feeHeadWiseCollectionReportStore = 'feeandpayment.reports.FeeHeadWiseCollectionReportStore';
Ext.define('Academia.view.feeandpayment.reports.FeeHeadWiseCollectionReportGrid', {
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.feeheadwisecollectionreportgrid',
	store : feeHeadWiseCollectionReportStore,
	title : getFeeAndPaymentCommonTranslation('FEE_HEAD_WISE_REPORT'),
	border : true,
	autoScroll : false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	cls:'centerAlignTitle',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false 
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW  
	}],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins : [ 'pagesize' ],
			store : 'feeandpayment.reports.FeeHeadWiseCollectionReportStore',
			emptyMsg : getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	} ],
	initComponent : function() {
		var grid = this;
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	   tbar : ['->',{
			xtype : 'button',
			itemId : 'exportFeeHeadWiseReportsIdPDF',
			tooltip : getCommonTranslation('EXPORT_REPORTS_PDF'),
			text : getCommonTranslation('EXPORT_REPORTS_PDF'),
			formBind:true,
			disabled:true,
		},{
			xtype : 'button',
			itemId : 'exportFeeHeadWiseReportsId',
			tooltip : getCommonTranslation('EXPORTREPORTS'),
			text : getCommonTranslation('EXPORTREPORTS'),
			formBind:true,
			disabled:true,
		}],
					columns : [{
						header : getCommonTranslation('FEE_HEAD_GROUP'),
						dataIndex : 'groupingFeeHeadName',
						flex:1,
						hidden:true
							},{
								header : getCommonTranslation('FEE_HEAD'),
								dataIndex : 'feeHeadName',
								flex : 1,
								/*summaryRenderer : function(value, summaryData,
										dataIndex) {
									return getFeeAndPaymentCommonTranslation('TOTAL');
								}*/
								summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
									if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
									// a = currencyRenderer('',store.data.items[0].data.acadLocBaseCurrencyId).split(" ");
										return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
									}
									else {
										return getFeeAndPaymentCommonTranslation('TOTAL');
									}
								}
							},{
								header : getCommonTranslation('STUDENT_COUNT'),
								dataIndex : 'studentCount',
								flex : 1,
								renderer : function(value, meta, record) {
									if (!isNullOrEmpty(value)) {
										if (record.data.feeHeadId == 0) {
											return value;
										} else {
											return '<a href=#>' + value
													+ '</a>'
										}
									}
								}
							},{
								header : getCommonTranslation('TOTAL_AMOUNT'),
								dataIndex : 'totalBillAmount',
								flex : 1,
								summaryType : 'sum',
								//align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
								renderer : function(value, metaData, record,
										row, col, store, gridView) {
									if (!isNullOrEmpty(record.get("currencyId"))) {
										return currencyRenderer(value, record
												.get("currencyId"));
									}
								},
								/*summaryRenderer : function(value, summaryData,
										dataIndex, rowIndex, colIndex, store,
										view) {
									return value;
								},*/
								summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
									if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
										return currencyRenderer(value.toFixed(2),store.data.items[0].data.currencyId);
									}
									else {
										return value.toFixed(2);
									}
								}
							},{
								header : getCommonTranslation('BILL_AMOUNT_PAID'),
								dataIndex : 'totalNetCollectionAmount',
								flex : 1,
								summaryType : 'sum',
								//align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
								renderer : function(value, metaData, record,
										row, col, store, gridView) {
									if (!isNullOrEmpty(record.get("currencyId"))) {
										return currencyRenderer(value, record
												.get("currencyId"));
									}
								},
								/*summaryRenderer : function(value, summaryData,
										dataIndex, rowIndex, colIndex, store,
										view) {
									return value;
								}*/
								summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
									if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
										return currencyRenderer(value.toFixed(2),store.data.items[0].data.currencyId);
									}
									else {
										return value.toFixed(2);
									}
								}
							},{
								header : getCommonTranslation('OUT_STANDING'),
								dataIndex : 'totalOutstandingAmount',
								flex : 1,
								summaryType : 'sum',
								//align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
								renderer : function(value, metaData, record,
										row, col, store, gridView) {
									if (!isNullOrEmpty(record.get("currencyId"))) {
										return currencyRenderer(value, record
												.get("currencyId"));
									}
								},
								/*summaryRenderer : function(value, summaryData,
										dataIndex, rowIndex, colIndex, store,
										view) {
									return value;
								}*/
								summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
									if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
										return currencyRenderer(value.toFixed(2),store.data.items[0].data.currencyId);
									}
									else {
										return value.toFixed(2);
									}
								}
							}]

				});
