/**
 *  @author Rajkumar.patidar
 */

/*var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function( editor, context, e ){ 
		}
	}
});*/

Ext.define('Academia.view.feeandpayment.schedulepayment.SchedulePaymentListForInstallment', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.schedulepaymentlistforinstallment',
	store : 'feeandpayment.PaymentScheduleForAdhoc',
	border: true,
	selType:'checkboxmodel',
	selModel : {
		mode : 'MULTI',
		showHeaderCheckbox : true,
		allowDeselect : true,
		checkOnly : true,
		renderer : function(value, metaData, record, rowIndex,
				colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix
					+ 'grid-cell-special ' + baseCSSPrefix
					+ 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix
					+ 'grid-row-checker">&#160;</div>';
		}
	},
	cls: 'scheduleInstallmentGridCls',
	//autoScroll: true, V2D-329863
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.PaymentScheduleForAdhoc',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		text:getFeeAndPaymentCommonTranslation('SAVE'),
		tooltip: getFeeAndPaymentCommonTranslation('SAVE')
	}],
	columns: [{
		hidden:true,
		dataIndex:'id'
	},{
		header : getFeeAndPaymentCommonTranslation('INSTALLMENT_NO'),
		dataIndex : 'sequence',
		flex : 1	  
	},{
		header : getFeeAndPaymentCommonTranslation('NO_OF_DAYS_AFTER_ENROLLMENT'),
		dataIndex : 'noOfDays',
		flex : 1,
		editor : {
			xtype:'numberfield',
			name: 'noOfDays',
			itemId:'noOfDays',
			mouseWheelEnabled:false,
			allowDecimals:true,
			hideTrigger:true,
			minValue:0,
			maxValue:999,
			maxLength:3
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{
		header : getFeeAndPaymentCommonTranslation('DUE_DAYS'),
		dataIndex : 'dueDays',
		flex : 1,
		editor : {
			xtype:'numberfield',
			name: 'dueDays',
			itemId:'dueDays',
			mouseWheelEnabled:false,
			allowDecimals:true,
			hideTrigger:true,
			minValue:0,
			maxValue:999,
			maxLength:3
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{ 
		header : getFeeAndPaymentCommonTranslation('DUE_DATE'),
		dataIndex : 'dueDate',
		flex : 1,
		editor: {
			xtype: 'datefield',
			name: 'dueDate',
			itemId:'dueDate',
			minValue : new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			editable:true
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{ 
		header : getFeeAndPaymentCommonTranslation('AMOUNT'),
		dataIndex : 'amount',
		flex : 1,	  
		editor : {
			xtype:'numberfield',
			name: 'amount',
			itemId:'amount',
			mouseWheelEnabled:false,
			allowDecimals:true,
			hideTrigger:true,
			minValue:0
		},    
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		} 
	}],
	plugins: {
		ptype : 'cellediting',
		clicksToEdit: 1
	},
	listeners: {
		beforeedit: function(editor, context) {
			var gridStore= context.grid.getStore();
			Ext.each(gridStore.data.items, function(items){
				if(!isNullOrEmpty(items.data.dueDate)){
					context.grid.columns[3].getEditor().setReadOnly(true);
					return false;
				}else{
					context.grid.columns[3].getEditor().setReadOnly(false);
				}

				if(!isNullOrEmpty(items.data.dueDays)){
					context.grid.columns[4].getEditor().setReadOnly(true);
					return false;
				}else{
					context.grid.columns[4].getEditor().setReadOnly(false);
				}
			});
			/*if(!isNullOrEmpty(context.record.get('dueDate'))){
				context.grid.columns[3].getEditor().setReadOnly(true);
			}
			else{
				context.grid.columns[3].getEditor().setReadOnly(false);
			}
			if(!isNullOrEmpty(context.record.get('dueDays'))){
				context.grid.columns[4].getEditor().setReadOnly(true);
			}
			else{
				context.grid.columns[4].getEditor().setReadOnly(false);
			}*/
			return context.colIdx !== 0;
		},
		cellclick: function (sender, td, cellIndex, record, tr, rowIndex, e, eOpts) {
			clickedColIndex = cellIndex;
		},
		beforedeselect: function (rowmodel, record, index, eOpts) {
			return (clickedColIndex == 0);
		},
		headerclick:function(header, column, e, t,eOpts){
			clickedColIndex = 0;
		}

	}
});