/**
 * @author Amit Gupta
 */

Ext.define('Academia.view.filemanagement.FileForwardWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.fileforwardwin',
	title:getFileManagementTranslation('FORWARD_TO'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		formCode:'fileassigntoform',
		itemId:'winFileassigntoform',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			//width:440,
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			itemId:'fileAssignContainerId',
			items:[{
				xtype : 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					width:226,
					labelAlign: 'top'
				},
				items : [{
					xtype: 'customcombobox',
	                name: 'userType',
	                itemId: 'userType',
	                fieldLabel: getFileManagementTranslation('USER_TYPE'),
	                editable: true,
	                valueField: 'id',
	                displayField: 'userGroupName',
	                allowBlank:false,
	                store: 'attendance.UserGroup'
	              
				},{
					xtype: 'customcombobox',
					name:'assignedUser',
					itemId:'assignedUser',
					fieldLabel : getFileManagementTranslation('USER'),
					store: 'hostel.roomallocation.UserSmartSearchByUserType',
					msgTarget: 'qtip',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'codeOrName',
					minChars:3,
					allowBlank: false,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listeners:{
						render : function(combo){
							var store=Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType');
							combo.bindStore(store)
						}
					},
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				}]
				}]
		},{
			
			xtype:'fieldcontainer',
			itemId:'filAssignToId',
			items:[{
				xtype : 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					width:226,
					labelAlign: 'top'
				},
				items : [{
					xtype: 'datefield',
					name: 'assignmentDate',
					itemId:'assignmentDate',
					//--submitFormat:CONSTANTS.DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype: 'daterange',
					endDateField: 'dueDate',
					editable:false,
					allowBlank:false,
					fieldLabel:getFileManagementTranslation('DATE_OF_ASSIGNMENT'),
//					value:new Date()
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);						
							obj.setValue(new Date());
						}
					}
				},{
					xtype: 'datefield',
					name: 'dueDate',
					itemId:'dueDate',
					//--submitFormat:CONSTANTS.DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype: 'daterange',
					startDateField: 'assignmentDate',
					editable:false,
					fieldLabel:getFileManagementTranslation('DUE_DATE')
				}]
			}]

		},{
			xtype: 'textarea',
			name:'remarks',
			itemId:'remarks',
			width: 460,
			maxLength : 250,
			fieldLabel: getFileManagementTranslation('REMARKS')
		},{
			xtype:'fieldcontainer',
			//width:'100%',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});
