/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.filemanagement.ManageAssignedFilesFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.manageassignedfilesfilter',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width:226
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'fileType',
			itemId: 'fileTypeId',
			fieldLabel:getServiceRequestTranslation('FILE_TYPE'),
			store:'filemanagement.FileTypeStore',
			valueField: 'id',
			displayField: 'value',
			queryParam:'fileType',
			minChars:3,
			//width:460,
			typeAhead:false,
			editable: false,
            disableKeyFilter: false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			//enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name:'fileNo',
			itemId:'fileNoId',
			store:'filemanagement.FileNumberStore',
			fieldLabel:getServiceRequestTranslation('FILE_NO'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'fileNo',
			minChars:3,
//			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype:'customcombobox',
			name:'fileOwner',
			itemId:'fileOwnerId',
			fieldLabel : getFileManagementTranslation('FILE_OWNER'),
			store: 'criteriabuilder.userquicksearch.QuickSearchName',
			msgTarget: 'qtip',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		}]
	},{
		xtype:'fieldset',
		title:getServiceRequestTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		width:'100%',
		defaults: {
			labelAlign: 'top',
			//width:226
		},
		style: {
			marginTop: '40px!important',
			//marginLeft:'-10px !important'
		},
		items:[{
			xtype:'fieldcontainer',
			layout: 'hbox',
			style: {
				//marginTop: '40px!important',
				marginLeft:'-0px !important'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[/*{
				xtype:'customcombobox',
				name:'fileStatus',
				itemId:'fileStatusId',
				store:'filemanagement.FileStatusStore',
				fieldLabel:getFileManagementTranslation('CURRENT_STATUS'),
				minChars:3,
				valueField: 'id',
				displayField: 'value',
				editable: false,
	            disableKeyFilter: false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true
			},*/{
				xtype:'customcombobox',
				name:'priority',
				itemId:'priorityId',
				store:'filemanagement.FilePriorityStore',
				allowBlank:true,
				fieldLabel: getFileManagementTranslation('PRIORITY'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
	            disableKeyFilter: false,
				typeAhead:true,
				disabled:false,
				forceSelection:true 
			},{
				xtype:'customcombobox',
				name:'acknowledgment',
				itemId:'acknowledgment',
				store:'filemanagement.FileAcknowledeStore',
				fieldLabel: getFileManagementTranslation('ACKNOWLEDGMENT_STATUS'),
				minChars:3,
				valueField: 'id',
				displayField: 'value',
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				editable: false,
	            disableKeyFilter: false,
				forceSelection:true
			}]
		},{

			/*xtype:'label',
			text:'<u>'+ getCommonTranslation('ENQUIRY_INFORMATION')+'</u>',
//			labelStyle: 'font-weight:bold',
			style: 'font-weight:bold;',*/
			xtype:'displayfield',
			value:'<b class="menu-title">'+getServiceRequestTranslation('CREATION_DATE')+'</b>',
			style: {
				textDecoration: "underline"
			}
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			style:{
//				marginTop:'40px!important'
			},
			items:[{
				xtype: 'datefield',
				name:'creationFromDate',
				itemId:'creationFromDate',
				fieldLabel:getServiceRequestTranslation('FROM_DATE'),
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				endDateField: 'creationToDate',
				editable:false,
			},{
				xtype: 'datefield',
				name:'creationToDate',
				itemId:'creationToDate',
				fieldLabel:getServiceRequestTranslation('TO_DATE'),
				vtype: 'daterange',
				startDateField: 'creationFromDate',
				editable:false,
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
			}]	
		},{

			/*xtype:'label',
			text:'<u>'+ getCommonTranslation('ENQUIRY_INFORMATION')+'</u>',
//			labelStyle: 'font-weight:bold',
			style: 'font-weight:bold;',*/
			xtype:'displayfield',
			value:'<b class="menu-title">'+getCommonTranslation('DUE_DATE')+'</b>',
			style: {
				textDecoration: "underline"
			}
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			style:{
//				marginTop:'40px!important'
			},
			items:[{
				xtype: 'datefield',
				name:'due_fromDate',
				itemId:'due_fromDateId',
				fieldLabel:getServiceRequestTranslation('FROM_DATE'),
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				endDateField: 'due_toDateId',
				editable:false,
			},{
				xtype: 'datefield',
				name:'due_toDate',
				itemId:'due_toDateId',
				fieldLabel:getServiceRequestTranslation('TO_DATE'),
				vtype: 'daterange',
				startDateField: 'due_fromDateId',
				editable:false,
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
			}]	
		}]
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			//formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
