/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.hostelattendance.HostelAttendanceGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.hostelattendancegrid',
	store :'hostel.hostelattendance.HostelAttendanceGridStr',
	title: getHostelTranslation('LIST_OF_STUDENTS'),
	border: true,
	refreshStoreData:true,
	//selType:'checkboxmodel',
	selModel : {
		selType : 'checkboxmodel',
		mode : 'SIMPLE',
		select: function(records, keepExisting, suppressEvent) {
			if (Ext.isDefined(records)) {
				this.doSelect(records, keepExisting, suppressEvent);
			}
		},
		selectAll: function(suppressEvent) {
			var me = this,
			selections = me.store.getRange();

			for(var key in selections) {
				if( selections[key].data.id == '3' ) {
					selections.splice( key, 1 );
					break;
				}
			}
			var i = 0,
			len = selections.length,
			selLen = me.getSelection().length;

			if(len != selLen) {
				me.bulkChange = true;
				for (; i < len; i++) {
					me.doSelect(selections[i], true, suppressEvent);
				}
				delete me.bulkChange;
				me.maybeFireSelectionChange(me.getSelection().length !== selLen);
			}
			else {
				me.deselectAll(suppressEvent);
			}
		}
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.hostelattendance.HostelAttendanceGridStr',
			emptyMsg :getHostelTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		//grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},tbar: [/*{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},*/{
		xtype : 'button',
		text : getCommonTranslation('UPDATE_ATTENDANCE'),
		name : 'btnUpdateAttendanceGrid',
		itemId : 'updateAttendanceItemId'
	}, '->',{
        xtype: 'button',
        itemId: 'exportReportItemId',
        tooltip: getCommonTranslation('EXPORTREPORTS'),
        text: getCommonTranslation('EXPORTREPORTS'),
    }],
	columns: [{
		header : getHostelTranslation('OCCUPANTID'),
		dataIndex : 'occupantId',
		flex:1
	},{
		header : getHostelTranslation('OCCUPANT_NAME'),
		dataIndex : 'occupantName',
		flex:1
	},{
		text : getHostelTranslation('CITY'),
		dataIndex : 'city',
		hidden:true,
		flex:1
	},{
		text : getHostelTranslation('PROGRAM'),
		dataIndex : 'programName',
		hidden:true,
		flex:1
	},{
		text : getHostelTranslation('BATCH'),
		dataIndex : 'batchName',
		hidden:true,
		flex:1
	},{
		header : getHostelTranslation('HOSTEL'),
		dataIndex : 'hostel',
		flex:1
	},{
		header : getHostelTranslation('BUILDING'),
		dataIndex : 'building',
		flex:1
	},{
		header : getHostelTranslation('FLOOR'),
		dataIndex : 'floor',
		flex:1
	},{
		header : getHostelTranslation('ROOM_NO'),
		dataIndex : 'roomNo',
		flex:1
	},{
		header : getHostelTranslation('BED_NO'),
		dataIndex : 'bedNo',
		flex:1
	},{
		header : getHostelTranslation('ATTENDANCE_DATE'),
		dataIndex : 'attendanceDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	}/*,{
		header : getCommonTranslation('REMARKS'),
		dataIndex : 'remarks',
		flex:1,
		hidden:true
	},{
		header : getHostelTranslation('ATTENDANCE_TIME'),
		dataIndex : 'attendanceTime',
		flex:1,
        renderer:function(value, record){
        	return timeRender(value);
        }
	},{
		header : getHostelTranslation('ATTENDANCE_STATUS'),
		dataIndex : 'attendanceStatus',
		flex:1,
		 editor : {
			 xtype: 'customcombobox',
			 itemId:'hostelAttendanceStatusId',
			 store:'hostel.hostelattendance.HostelAttendanceStatusStore',
			 valueField : 'value1',
			 displayField : 'value',
			 typeAhead:false,
	            listeners: {
	                render: function(combo) {
	                	combo.setValue("");
	                    var store = Ext.create('Academia.store.hostel.hostelattendance.HostelAttendanceStatusStore');
	                    combo.bindStore(store);
	                },
	            	focus: function(combo, eOpt) {
	            		combo.setRawValue(getCommonTranslation(combo.getValue()));
	            		combo.setLastValue(getCommonTranslation(combo.getValue()));
	            	},
	                blur: function(combo, r) {
	                    combo.setValue(combo.getValue());
	                    combo.setRawValue(getCommonTranslation(combo.getValue()));
	            	//	combo.setLastValue(getCommonTranslation(combo.getValue()));
	                },
	                change: function(combo, eOpt) {
	                	combo.setRawValue(getCommonTranslation(combo.getValue()));
	            		//combo.setLastValue(getCommonTranslation(combo.getValue()));
	                }
	            }
		 },
		renderer:function(value,record){
			if (!isNullOrEmpty(value)){
				if(value == 'PRESENT' || value == 'Present'){
					return 'Present';
				}else if(value == 'ABSENT' || value == 'Absent'){
					return 'Absent'; 
				}else if(value == 'LEAVE' || value == 'Leave'){
					return 'Leave';
				}else if(value == 'LATE_ARRIVAL' || value == 'Late Arrival'){
					return 'Late Arrival';
				}
			}
		}
	
	}*/],
	 plugins: [/*{
		 ptype : 'cellediting',
		 clicksToEdit: 1,
		 listeners: {
			 edit: function(obj, editor, context){
				 var this$= this;
				 var grid = obj.grid;
				 var store = grid.getStore();
				 var models = grid.getStore().getRange();
				 for(var i =0; i<store.data.length;i++){
					 if(editor.rowIdx==i){
						 models[i].set('present', true);
						 models[i].set('absent', true);
					 }
				 }
			 }
		 }
	 },*/
	 {
	   	 ptype: 'rowexpander',
		     pluginId:'hostelAttandanceRowExpander',
		     rowBodyTpl:new Ext.XTemplate('<table style="border:1px solid black; width: 50%;">', 
		    		 '<tr>',
		    		 '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + 'Attendance Time' + '</th>',
		    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + 'Attendance Status' + '</th>',
		    			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + 'Remarks' + '</th>',
		    		 '</tr>',
		    		 '<tpl for="attendanceData">',
		    		 '<tr>',
		    		 '<td style="width:100px;text-align:center">{[this.timeFormatChange(values.attendanceTime)]}</td>', 
		    		 '<td style="width:100px;text-align:center">{[this.updateStatus(values.attendanceStatus)]}</td>',
		    		 '<td style="width:100px;text-align:center">{remarks}</td>',
		    		 '</tr>',    		
		    		 '</tpl>',
		    		 '</table>',{
		    	 timeFormatChange: function(inputValue) {
		    		 return timeRender(inputValue);
		    	 },
		    	 updateStatus: function(value) {
		    		 //return timeRender(inputValue);
		    		 if (!isNullOrEmpty(value)){
		 				if(value == 'PRESENT' || value == 'Present'){
		 					return 'Present';
		 				}else if(value == 'ABSENT' || value == 'Absent'){
		 					return 'Absent'; 
		 				}else if(value == 'LEAVE' || value == 'Leave'){
		 					return 'Leave';
		 				}else if(value == 'LATE_ARRIVAL' || value == 'Late Arrival'){
		 					return '<span style="color: Red;">Late Arrival</span>';
		 				}
		 			}
		    	 }
		     })
	   }]
});