Ext.define('Academia.view.hostel.reports.roomallocationreport.RoomAllocationSearchReport', {
    extend: 'Ext.form.Panel',
    alias: 'widget.roomallocationsearchreport',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
				xtype: 'customcombobox',
				name:'userType',
				itemId:'userType',
				store:'attendance.UserGroup',
				fieldLabel: getHostelTranslation('USER_TYPE'),
				valueField: 'id',
				displayField: 'userGroupName',
	            editable: false,
	            forceSelection: true,
				typeAhead:false
            }, {
            	xtype: 'customcombobox',
				name: 'studentName',
				itemId: 'studentName',
				fieldLabel: getHostelTranslation('NAME'),
				//store: 'hostel.roomallocation.UserSmartSearchByUserType',
				store: Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				//disabled:true,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					},
            listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			}
				}
            },{
				xtype: 'customcombobox',
				name: 'roomType',
				itemId: 'roomTypeId',
				fieldLabel: getHostelTranslation('ROOM_TYPE'),
				store:'hostel.manageroomtype.RoomType',
				displayField:'roomType',
				valueField:'id',
				typeAhead:true,
				forceSelection:true
			}]
        },{
        	xtype:'fieldset',
    		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
//    		layout:'hbox',
    		frame:true,	
    		collapsible:true,
    		collapsed:true,
    		width:'100%',
    		/*defaults: {
    			labelAlign: 'top',
    			width:226
    		},*/
    		style: {
             	 marginTop: '40px!important'
            },
			items:[{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [ {
                xtype: 'customcombobox',
                fieldLabel: getHostelTranslation('ACADEMY_LOCATION'),
                width: 460,
                store : 'user.UserAcademyLocationStore',
                name: 'academyLocation',
                itemId: 'academyLocation',
                valueField: 'id',
                displayField: 'value',
                typeAhead: true,
                forceSelection: true,
                triggerAction: 'all',
                minChars:3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR')
            },{
                xtype: 'customcombobox',
                fieldLabel: getHostelTranslation('HOSTEL_CODE_NAME'),
                store : 'hostel.managehostel.hostel.HostelCodeName',
                editable : false,
                name: 'hostelCodeName',
                itemId: 'hostelCodeName',
                valueField: 'id',
                displayField: 'value'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getHostelTranslation('BUILDING_CODE_NAME'),
                store : 'hostel.managehostel.building.BuildingCodeName',
                editable : false,
                name: 'buildingCodeName',
                itemId: 'buildingCodeName',
                valueField: 'id',
                displayField: 'value'
            },{
                xtype: 'customcombobox',
                name: 'floorCodeNo',
                itemId: 'floorCodeNo',
                store:'hostel.managehostel.floor.FloorCodeName',
                fieldLabel: getHostelTranslation('FLOOR_NO'),
                editable: false,
                displayField: 'value',
                valueField: 'id',
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getHostelTranslation('ROOM_NO'),
                store : 'hostel.managehostel.floor.RoomCodeName',
                editable : false,
                name: 'roomNo',
                itemId: 'roomNo',
                valueField: 'id',
                displayField: 'value'
            },{
                xtype: 'customcombobox',
                name: 'status',
                itemId: 'status',
                store:'hostel.managehostel.room.RoomDetailsStatus',
                fieldLabel: getHostelTranslation('STATUS'),
                editable: false,
                displayField: 'value',
                valueField: 'id',
            }]
        },{
        	xtype : 'fieldcontainer',
        	width: '100%',
        	defaults : {
        		width : 226,
        		labelAlign : 'top'
        	},
        	items : [{
        		xtype:'displayfield',
        		value:'<b class="menu-title">'+getHostelTranslation('AVAILABLITY_DATES')+'</b>',
        		style: {
        			textDecoration: "underline"
        		}
        	},{ 
        		xtype : 'fieldcontainer',
        		width: '100%',
        		layout:'hbox',
        		defaults : {
        			width : 226,
        			labelAlign : 'top'
        		},
        		items : [{
        			xtype : 'datefield',
        			fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
        			name : 'fromDate',
        			itemId:'fromDate',
        			endDateField : 'toDate',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
        			minValue:new Date(),
        			vtype : 'daterange'
        		},{
        			xtype : 'datefield',
        			fieldLabel :getProgramandcourseTranslation('TO_DATE'),
        			name : 'toDate',
        			itemId : 'toDate',
        			startDateField : 'fromDate',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
        			vtype : 'daterange'
        		}]
        	}
        	]}],
             listeners:{
     			render: function(myfieldset){
     				myfieldset.setMargin('-10px');
     			}
     		}
        }, {
        	xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SEARCH'),
				itemId : 'searchButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				formBind:true,
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'resetButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			} ]
		}]
});
