/**
 * Surendra Jha
 */
Ext.define('Academia.view.hostel.roomallocation.userwise.AllottedDetailsGrid', {
	extend: 'Ext.grid.Panel',
    alias : 'widget.allottedDetailsGrid',
    store : 'hostel.roomallocation.userwise.CancelAllotmentList',
    border: true,
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
    	var grid=this;
    	this.callParent(arguments);
    },
    columns : [{
		header :getHostelTranslation('OCCUPANTID'),
		dataIndex : 'code',
		flex:1
	},{
		header : getHostelTranslation('OCCUPANT_NAME'),
		dataIndex : 'name',
		flex:1
	},{
		header : getHostelTranslation('ALLOTMENT_STATUS'),
		dataIndex : 'allotmentStatus',
		flex:1
	},{
		header : getHostelTranslation('BED_NO'),
		dataIndex : 'bedNo',
		flex:1
	},{
		header : getHostelTranslation('FEE_PAYMENT'),
		dataIndex : 'feePaymentStatus',
		flex:1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'DONE' || value == 'Done'){
					return '<span style="color:green;">' + getHostelTranslation('DONE') + '</span>';
				}else if(value == 'PENDING' || value == 'Pending'){
					return '<span style="color:red;">' + getHostelTranslation('PENDING') + '</span>';
				} 
			}else{
				return '-';
			}
		}
	}]
});
