/**
 * @author Ramkrishna Yadav
 */
Ext.define('Academia.view.hrRecruitmentProcess.jobApplication.JobApplicationFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.jobapplicationfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('APPLICATION_ID'),
			name: 'jobCode',
			itemId:'jobCode',
			editable: true,
			store: 'hrRecruitmentProcess.jobApplication.JobApplicantionCodeComboStore',
			displayField: 'code',
			valueField: 'code',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'jobCode',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}, {
			xtype: 'customcombobox',
			fieldLabel:getCommonTranslation("JOB_APPLICATION_NAME"),
			name: 'jobApplicationName',
			itemId:'jobApplicationName',
			editable: true,
			store: 'hrRecruitmentProcess.jobApplication.JobApplicantionNameComboStore',
			displayField: 'value',
			valueField: 'value',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'applicantName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("APPLICATION_STATUS"),
			name: 'jobApplicationStatus',
			itemId:'jobApplicationStatus',
			editable: true,
			store: 'hrRecruitmentProcess.jobApplication.jobApplicationStatusStore',
			displayField:'name',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true
			
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("ACADEMY_LOCATION"),
			name: 'academyLocationId',
			itemId:'academyLocationCombo',
			editable: true,
			store: 'user.UserAcademyLocationStore',
			displayField: 'value',
			valueField: 'id',
			minChars:3,
			width:460,
			typeAhead:true,
			forceSelection :true,
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'textfield',
			name: 'EMAIL_ID',
			itemId: 'emailID',
			vtype: 'email',
			fieldLabel: getAdmissionTranslation('EMAIL_ID')  
		},{
			xtype: 'numberfield',
			name: 'MOBILE_NO',
			itemId: 'mobileNo',
			fieldLabel: getAdmissionTranslation('MOBILE_NO'),
			spinUpEnabled : false,
			spinDownEnabled : false,
			hideTrigger : true,
			enforceMaxLength : true,
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('COUNTRY'), //Program Group
			name: 'COUNTRY_ID',
			autoload: false,
			itemId: 'countryCombo',
			store: 'common.CountryStore',
			valueField: 'id',
			displayField: 'countryName',
			//queryMode : 'local',
			queryParam:'countryName',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
			
		}]
	},,{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype : 'customcombobox',
			fieldLabel :getProgramandcourseTranslation('DEPARTMENT'),						
			name : 'departmentId',
			itemId : 'departmentId_itemId',
			store : 'course.CourseDepartmentStore',
			displayField : 'value',
			valueField : 'id'							
				//allowBlank:false
		}, {
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("JOB_TITLE"),
			name: 'jobTitle',
			itemId:'jobTitle',
			editable: true,
			store: 'hrRecruitmentProcess.jobPosting.JobTitleComboStore',
			displayField: 'value',
			valueField: 'value',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'jobTitle',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
            xtype: 'customcombobox',
            itemId: 'lmDesignationCombo',
            fieldLabel: getPersonModuleTranslation('DESIGNATION'),
            store: 'common.DesignationTypeStore',
            valueField: 'id',
            displayField: 'value',
            name: 'lmDesignationCombo',
            editable: false,
            triggerAcation: 'all',
            fourceSelection: true,
        }]
    }, {
        xtype: 'fieldset',
        collapsible: true,
        collapsed: true,
        title: getServiceRequestTranslation('MORE_FILTERS'),
        titleCollapse: true,
        defaults: {
            labelAlign: 'top',
        },
        style: {
            marginTop: '33px!important'
        },
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
            	xtype: 'numberfield',
    			name: 'yearsOfExperience',
    			itemId:'yearsOfExperience',
    			spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				enforceMaxLength : true,
    			
    			fieldLabel:getCommonTranslation('YEARS_OF_EXPERIENCE')
    		},{
            	xtype: 'customcombobox',
                itemId: 'highestQualification',
                fieldLabel: getPersonModuleTranslation('HIGHEST_QUALIFICATION'),
                store: 'common.ExamPassedStore',
                valueField: 'id',
                displayField: 'value',
                name: 'highestQualification',
               
                
            },{
    			xtype: 'numberfield',
    			name: 'noticePeriod',
    			itemId:'noticePeriod',
    			fieldLabel:getCommonTranslation('NOTICE_PERIOD'),
    			spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				enforceMaxLength : true,
    			
    		}]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
				xtype : 'customcombobox',
				name : 'employeeLanguage',	
				itemId:'employeeLanguage',
				fieldLabel:getCommonTranslation('LANGUAGE'),
			    store:'common.MultiLanguageStore',
				valueField: 'id',
				displayField: 'value',
				editable: false,
	            disableKeyFilter: false,
				forceSelection:true,
				
			},{
    			xtype: 'datefield',
    			name: 'fromDate',
    			itemId:'fromDateId',
    			endDateField:'tillDateId',
    			vtype: 'daterange',
    			fieldLabel:getCommonTranslation('START_DATE'),
    			listeners: {
    				render: function(obj) {
    					return dateFormatRender(obj);					
    				}
    			}
    		},{
    			xtype: 'datefield',
    			name: 'tillDate',
    			itemId:'tillDateId',
    			startDateField:'fromDateId',
    			vtype: 'daterange',
    			fieldLabel:getCommonTranslation('END_DATE_LABEL'),
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			}
    		}]
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnJobApplicationItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBtnJobApplicationItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});