/*
 *@author Deepak S
 * 
 */
Ext.define('Academia.view.hrRecruitmentProcess.jobPosting.JobPostingApplyToForm', {
	extend: 'Ext.form.Panel',
    alias: 'widget.jobpostingapplytoform',
    bodyPadding:'10 10 10 10',
    autoScroll: false,
    frame: true,
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    layout: {
        type: 'vbox'
    },
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
    itemId: 'jobpostingapplytoform',
    title: getCommonTranslation('MAP_ACADEMY_LOCATIONS'),
    items: [{
		xtype:'fieldcontainer',
		itemId:'jobPostingContainerId',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				width:226,
				labelAlign: 'top'
			},
			items : [{
				xtype: 'hidden',
				name: 'jobMappingId',
			},{
	            xtype: 'customcombobox',
	            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
	            name: 'academyLocation',
	            itemId: 'academyLocationId',
	            editable: false,
	            allowBlank: false,
	            store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
	            displayField: 'value',
	            valueField: 'id'
	            //            queryMode:'local'		
	        },{
	            xtype: 'nestedJsonCombo',
	            fieldLabel: getCommonTranslation('DEPARTMENT'),
	            name: 'department',
	            itemId: 'jobPostingDepartmentId',
	            store: Ext.create('Academia.store.department.DepartmentAcademyLocationWiseStore'),
	            valueField: 'id',
	            displayField: 'value',
	            editable: false,
	            allowBlank: false
	        },{
	    		xtype: 'customcombobox',
	    		itemId:'jobPostingDesignationComboId',
	    		fieldLabel: getPersonModuleTranslation('DESIGNATION'),
	    		store: Ext.create('Academia.store.common.DesignationTypeStore'),
				valueField: 'id',
				displayField: 'value',        
				name : 'designation',
				allowBlank: false,
				editable: false,
	    		triggerAcation: 'all',
	    		fourceSelection: true,
	    	},{
	            xtype: 'hiddenfield',
	            name: 'hiddenfield',
	            itemId: 'hidCkeditorTempId'
	        },{
	    		xtype: 'button',
	    		text: getCommonTranslation('ADD_VIEW_DESCRIPTION'),
	    		itemId: 'btnToAddCkEditor',
	    		cls: 'CustomBodyBtnSettings',
	    		style:{
					marginTop:'30px'
				},
				width:145
	    	},{
				xtype: 'button',
				itemId: 'addJobPostingBtn',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				style:{
					marginTop:'30px'
				}
			  }]
			}]
	}, {
    	xtype: 'fieldcontainer',
    	width: '100%',
    	items: [{
    		xtype: 'button',
    		itemId: 'btnSaveApplyToForm',
    		text: getCommonTranslation('SAVE'), //Save
    		ui: 'CustomBtnSubmit',
    		formBind: true,
    		scale: CONSTANTS.BUTTONSIZE
    	},{
    		xtype: 'button',
    		text: getCommonTranslation('RESET'),
    		itemId: 'btnResetApplyToForm',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE
    	}]
    }]
});
