/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.hrm.HRManagementEmployeeWiseAttendanceGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.hrmanagementemployeewiseattendancegrid',
	store: 'hrm.HRManagementEmployeeWiseAttendanceStore',
	title: getPersonModuleTranslation('HRM_ATTENDANCE_LIST'),
	border: true,
	frame: false,
	cls:'timeFieldZindexCls',
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'hrmanagementtabstructure': 1
		}
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		getRowClass: function(record, rowIndex, rowParams, store){
			return record.get("isUpdateByUser") ? "clsHRMRowGridBackColor" : "";
		}
	},/*headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'hrmanagementemployeewiseattendancestructure':1
		}
	},*/
	tbar: ['->', {
		xtype: 'button',
		itemId: 'exportReportItemId',
		tooltip: getCommonTranslation('EXPORTREPORTS'),
		text: getCommonTranslation('EXPORTREPORTS'),
		disabled:true
	}],
	columns: [{
		header: getCommonTranslation('DATE'),
		dataIndex: 'attendanceDate',
		flex: 1,
		sortable: false,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('DAY'),
		dataIndex: 'day',
		flex: 1,
		sortable: false
	}, {
		header: getPersonModuleTranslation('HRM_IN_TIME'),
		dataIndex: 'intime',
		flex: 1,
		sortable: false,
		editor: {
			xtype: 'timefield',
			name: 'inTime',
			itemId: 'inTimeItemId',
			format: CONSTANTS.DISPLAY_TIME_FORMAT,
			vtype: 'timerange',
			listeners: {
				focus: function(combo, eOpt) {
					//combo.setRawValue(timeRender(combo.getValue()));
					if (!isNullOrEmpty(combo.getValue())) {
						combo.setRawValue(timeRender(combo.getValue()));
					}
					else{
						var inTimeVal = combo.up('grid').getSelectionModel().getSelection()[0].data.intime;
						if (!isNullOrEmpty(inTimeVal)) {
							combo.setRawValue(timeRender(inTimeVal));
						}
					}
					var contentPanelMain = this.up('contentpanel');
					if(!isNullOrEmpty(contentPanelMain)){
						contentPanelMain.scrollBy(0,1);
						contentPanelMain.scrollBy(0,-1);
					}
				},
				blur: function(combo, r) {
					//combo.setValue(timeRender(combo.getValue()));
					/*if (!isNullOrEmpty(combo.getValue())) {
                		combo.setValue(timeRender(combo.getValue()));
                	}
                	else{
                		var inTimeVal = combo.up('grid').getSelectionModel().getSelection()[0].data.intime;
                		if (!isNullOrEmpty(inTimeVal)) {
                			combo.setValue(timeRender(inTimeVal));
                		}
                	}*/
				}/*,
                change: function(combo, newValue) {
                    combo.setRawValue(timeRender(combo.getValue()));
                }*/
			}
		},
		renderer: function(date, metaData, record, row, col, store, gridView) {
			if (!isNullOrEmpty(record)) {
				if(record.data.isArrivedLate){
					return '<span style="color:orange;">' + timeRender(date) + '</span>';
				}else{
					return timeRender(date);
				} 
			}
		}
	}, {
		header: getPersonModuleTranslation('HRM_OUT_TIME'),
		dataIndex: 'outtime',
		flex: 1,
		sortable: false,
		editor: {
			xtype: 'timefield',
			name: 'outTime',
			itemId: 'outTimeItemId',
			format: CONSTANTS.DISPLAY_TIME_FORMAT,
			vtype: 'timerange',
			listeners: {
				focus: function(combo, eOpt) {
					if (!isNullOrEmpty(combo.getValue())) {
						combo.setRawValue(timeRender(combo.getValue()));
					}
					else{
						var outTimeVal = combo.up('grid').getSelectionModel().getSelection()[0].data.outtime;
						if (!isNullOrEmpty(outTimeVal)) {
							combo.setRawValue(timeRender(outTimeVal));
						}
					}
					var contentPanelMain = this.up('contentpanel');
					if(!isNullOrEmpty(contentPanelMain)){
						contentPanelMain.scrollBy(0,1);
						contentPanelMain.scrollBy(0,-1);
					}
				},
				blur: function(combo, r) {
					//combo.setValue(timeRender(combo.getValue()));
					/*if (!isNullOrEmpty(combo.getValue())) {
                		combo.setValue(timeRender(combo.getValue()));
                	}
                	else{
                		var outTimeVal = combo.up('grid').getSelectionModel().getSelection()[0].data.outtime;
                		if (!isNullOrEmpty(outTimeVal)) {
                			combo.setValue(timeRender(outTimeVal));
                		}
                	}*/
				}/*,
                change: function(combo, eOpt) {
                    combo.setRawValue(timeRender(combo.getValue()));
                }*/
			}
		},
		renderer: function(date, metaData, record, row, col, store, gridView) {
			if (!isNullOrEmpty(record)) {
				if(record.data.isWentEarly){
					return '<span style="color:orange;">' + timeRender(date) + '</span>';
				}else{
					return timeRender(date);
				} 
			}
		}
	}, {
		header: getPersonModuleTranslation('HRM_TOTAL_TIME'),
		dataIndex: 'totaltime',
		flex: 1,
		sortable: false,
		renderer: function(val, metaData, record, row, col, store, gridView) {
			var totalTime = '' ; 
			if (val < 0)
				val = 86400000 + val;
			var totalTimeInMinutes = (val / 60000);
			var minutes = 0,
			hours = 0;
			var minutes = 0 + '' + (totalTimeInMinutes % 60);
			var hours = 0 + '' + (totalTimeInMinutes - minutes) / 60;
			totalTime = hours.substr(-2) + ':' + minutes.substr(-2);
			// return totalTime;
			if (!isNullOrEmpty(record)) {
				if(record.data.isLessHours){
					return '<span style="color:red;">' + totalTime + '</span>';
				}else{
					return totalTime;
				} 
			}
			else{
				return totalTime;
			}

		}

	}, {
		header: getPersonModuleTranslation('HRM_OVER_TIME'),
		dataIndex: 'overtime',
		flex: 1,
		sortable: false,
		renderer: function(val) {
			if (!isNullOrEmpty(val)) {
				if (val < 0)
					val = 86400000 + val;
				var totalTimeInMinutes = (val / (60*1000));
				var minutes = 0,
				hours = 0;
				var minutes = 0 + '' + (totalTimeInMinutes % 60);
				var hours = 0 + '' + (totalTimeInMinutes - minutes) / 60;
				var totalTime = hours.substr(-2) + ':' + minutes.substr(-2);
				return totalTime;
			} else {
				return '';
			}
		}
	}, {
		header: getPersonModuleTranslation('STATUS'),
		dataIndex: 'statusForGrid',
		flex: 1,
		sortable: false,
		editor: {
			xtype: 'customcombobox',
			name: 'attendanceStatus',
			store: 'hrm.HRMAttendanceMarkingTypeStatusStore',
			editable: false,
			valueField: 'value',
			displayField: 'value',
			listeners: {
				select:function(combo, records, eOpts){
					var grid = combo.up('hrmanagementemployeewiseattendancegrid');
					var rec = grid.editingPlugin.getActiveRecord();
					if(!isNullOrEmpty(rec)){
						rec.set('employeeAttendanceMarkingTypeId',records[0].data.id);
						rec.set('empAttendanceStatus',records[0].data.employeeAttendanceStatus);
						rec.set('statusForGrid',records[0].data.value);
					}
				}  
			}
		},
	}, {
		header: getCommonTranslation('LATE_ARRIVAL_EARLY_GOING'),
		dataIndex: 'lateArrivalEarlyGoing',
		flex: 1,
		sortable: false
	}, {
		header: getPersonModuleTranslation('REMARKS'),
		dataIndex: 'remarks',
		flex: 1,
		sortable: false
	}],
	plugins: [{
		ptype: 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(editor, context) {
				var hrmController = Academia.getApplication().getController('Academia.controller.hrm.HRManagementController');
				var portalId = hrmController.getCurrentLoggedPortalId();
				if (portalId == 2){
					return false;
				} else {
					var rowData = context.record.data;
					if (context.field == 'statusForGrid') {
						if (!context.record.raw.isStausEditable) {
							return false;
						}
					}
				}
			},
			edit: function(editor, e, eOpts) {
				var hrmController = Academia.getApplication().getController('Academia.controller.hrm.HRManagementController');
				hrmController.employeeWiseAttendanceRowEdit(e.record.data, e);
			}
		}
	}],
	listeners: {
		itemmouseenter: function(view, record, item) {
			if(record.get("isUpdateByUser")){
				Ext.fly(item).set({'data-qtip': getPersonModuleTranslation('HRM_ATTENDANCE_STATUS_TOOLTIP')});
			}
		}
	}
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
	clicksToEdit: 1,
	listeners: {
		beforeedit: function(editor, context, e) {}
	}
}); 