Ext.define('Academia.view.hrm.HRManagementEmployeeWiseAttendanceSummaryGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    //store : 'attendance.AttendanceCountStore',
    alias: 'widget.hrmanagementemployeewiseattendancesummarygrid',
    title: getProgramandcourseTranslation('ATTENDANCE_SUMMERY'),
    //id:'studentAttendancecountGridId',
    border: true,
    frame: false,
    refreshStoreData: true,
    //	selType:'checkboxmodel',
    cls: 'horizontalScrollingFixedl',
    headerFix:{
    	headerFix: true,
    	portalIdsWithStructure: {
    		'hrmanagementtabstructure': 1
    	}
    },
    viewConfig: {
        stripeRows: true
    },
    selModel: {
        mode: 'MULTI',
        showHeaderCheckbox: true,
        allowDeselect: false,
        checkOnly: true
    },
    columns: [
        /*{
        		header : 'ID',
        		hidden : true,
        		dataIndex:'id'
        	},*/
        {
            header: getPersonModuleTranslation('HRM_TOTAL_DAYS'),
            dataIndex: 'totalDays',
            flex: 1,
            sortable: false
        },{
            header: 'Total Working Days',
            dataIndex: 'totalWorkingDays',
            flex: 1,
            sortable: false
        }, {
            header: getPersonModuleTranslation('HRM_PRESENTS'),
            dataIndex: 'totalPresent',
            flex: 1,
            sortable: false
        }, {
            header: getPersonModuleTranslation('HRM_ABSENTS'),
            dataIndex: 'totalAbsent',
            flex: 1,
            sortable: false
        }, {
            header: getPersonModuleTranslation('HRM_LEAVES'),
            dataIndex: 'totalLeaves',
            flex: 1,
            sortable: false
        }, {
            header: getPersonModuleTranslation('HRM_LATE_ARRIVALS'),
            dataIndex: 'totalLateArrivals',
            flex: 1,
            sortable: false
        }, {
            header: getPersonModuleTranslation('HRM_EARLY_GOING'),
            dataIndex: 'totalEarlyGoing',
            flex: 1,
            sortable: false
        },{
            header: getPersonModuleTranslation('Compensatory Leaves'),
            dataIndex: 'totalCompensatoryLeave',
            flex: 1,
            sortable: false
        },{
            header: getPersonModuleTranslation('LOP'),
            dataIndex: 'totalLOP',
            flex: 1,
            sortable: false
        },{
            header: getPersonModuleTranslation('Others'),
            dataIndex: 'markingTypeStatusCount',
            flex: 1,
            sortable: false
        }, {
            header: getPersonModuleTranslation('HRM_ATTENDANCE_PERCENT'),
            dataIndex: 'attendancePercentage',
            flex: 1,
            sortable: false,
            renderer: function(value, metadata, record) {
                var msg = 0.0;
               /* if (!isNullOrEmpty(record.data.totalPresent)|| !isNullOrEmpty(record.data.otherPresent) || !isNullOrEmpty(record.data.totalWorkingDays)){
                	msg = (record.data.totalPresent  / record.data.totalWorkingDays);
                	if(isNaN(msg) || msg == 0){
                		return '-';
                	}
                	msg =  Ext.util.Format.number((msg * 100) , '0.00');
                	 return msg + '%';
                	}*/
                if (!isNullOrEmpty(record.data.attendancePercentage)){
                	msg = (record.data.attendancePercentage);
                	if(isNaN(msg) || msg == 0){
                		return '-';
                	}
                	msg =  Ext.util.Format.number((msg) , '0.00');
                	 return msg + '%';
                	}
                return msg;
            }
        }
    ]
});