/**
 * @author sohan chouhan
 * 
 */
Ext.define('Academia.view.hrm.availability.HRMAvailabilityFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hrmavailabilityfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
   // method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'employeeId',
            itemId: 'employeeItemId',
            fieldLabel: getPersonModuleTranslation('HRM_EMPLOYEE_ID'),
            store: 'hrm.timesheet.HRMTEmployeeSmartSearchStore',
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'codeOrName',
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            // triggerAction: '',
            hideTrigger: false,
            maxLength: 100,
            listConfig: {
                listeners: {
                    beforeshow: function(
                        picker) {
                        picker.minWidth = picker
                            .up('combobox')
                            .getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            }
        },{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('USER_GROUP_TYPE'),
			name:'USER_GROUP_TYPE',
			itemId : 'userGroupType',
			store: 'userGroup.UserGroupStore',
			valueField: 'id',
			displayField: 'userGroupName',
			//allowBlank: false,
			editable: false,
			queryMode : 'local'
		}, {
    		xtype: 'customcombobox',        
    	    itemId: 'cmbGlobalAcademyLocation',
    	    fieldLabel: getCommonTranslation('ACADEMY_LOCATION'), //Academy Location
    	    store: 'scholarships.LogedInUserAcademyLocationStore',	    
    	    valueField: 'id',
    	    displayField: 'academyLocationName',
    	    emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
    	    editable: true,	    
    	    queryMode: 'local',	    
    	    triggerAction: 'all',
    	    labelAlign:'top',
    	    typeAhead:true,
    	    anyMatch : true,
    	   // allowBlank: false,
    	    forceSelection: true
    }]
    } , {
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_DETAILS'),
		titleCollapse: true,
		defaults : {
			labelAlign:'top',
//			tdAttrs: { style: 'padding: 5px;' }
		},
		style: {
          	 marginTop: '33px!important'
         },
		items:[{
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 226
	        },
        items: [{
            xtype: 'customcombobox',
            itemId: 'empDepartment',
            fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
            valueField: 'id',
            displayField: 'name',
            name: 'DEPARTMENT',
            editable: false,
            triggerAcation: 'all',
            fourceSelection: true,
            store:'department.ParentDepartmentByAccesibleStore'
        }, {
		xtype:'customcombobox',
		overrideSetValue:false,
		fieldLabel:getCommonTranslation('SUB_DEPARTMENT'),
		name:'SUB_DEPARTMENT',
		itemId : 'getEmpSubDepartmentId',	
		valueField: 'id',
		displayField: 'name',
		editable: false,
		disabled:true,
		fourceSelection: true,	
		listeners: {
	            render: function(combo) {
	                var store = Ext.create('Academia.store.department.ChildDepartmentStore');
	                combo.bindStore(store);
	            }
	        }
	},{
			xtype: 'customcombobox',
			name: 'STATUS',
			itemId:'statusComboItemId',
			fieldLabel: getEnquiryTranslation('TRACK_ENQUIRY_STATUS'),
			valueField: 'code',
			displayField: 'value',
			typeAhead: true,
			forceSelection: true,
			store: {
				fields: [ 'value', 'code'],
				data : [
				        {"value":"Active", "code": "ACTIVE"},
				        {"value":"InActive", "code": "INACTIVE"},
				        ]
			}
		
        }]
		}]
         }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchEmpAvailFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetHRMAvailabilityFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            handler: function() {
                this.up('form').getForm().reset();
            }
        }]
    }]
});