/**
 * @author Varsha Gour
 * 
 */
Ext.define('Academia.view.hrm.report.HRMAttendancePunchLogReportFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hrmattendancepunchlogreportfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('FROM_DATE'),
            name: 'fromDate',
            itemId: 'fromDateItemId',
            endDateField: 'toDateItemId',
            format: CONSTANTS.DATE_FORMAT,
            allowBlank: false,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            vtype: 'daterange',
            editable:false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('To_Date'),
            name: 'toDate',
            itemId: 'toDateItemId',
            startDateField: 'fromDateItemId',
            format: CONSTANTS.DATE_FORMAT,
            allowBlank: false,
            editable:false,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('DEPARTMENT'),
            name: 'department',
            itemId: 'attendancePunchLogDepartmentItemId',
            store: 'department.DepartmentAcademyLocationWiseStore',
            valueField: 'id',
            displayField: 'value',
            editable: false
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('USER_GROUP_TYPE'),
            name: 'userGroupId',
            itemId: 'attendancePunchLogUserGroupItemId',
            store: 'userGroup.UserGroupStore',
            valueField: 'id',
            displayField: 'userGroupName',
            editable: false,
            queryMode: 'local'
        },
        {
        	xtype: 'customcombobox',
        	name: 'employeeId',
        	itemId: 'attendancePunchLogEmpItemId',
        	fieldLabel: getPersonModuleTranslation('HRM_EMPLOYEE_ID'),
        	store: 'hrm.HRMEAEmployeeSmartSearchStore',
        	valueField: 'id',
        	displayField: 'valueCode',
        	queryParam: 'codeOrName',
        	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	enableKeyEvents: 'true',
        	minChars: 3,
        	typeAhead: false,
        	forceSelection: true,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	//triggerAction: '',
        	hideTrigger: false,
        	maxLength: 100,
        	//allowBlank: false,
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{studentCode} / {studentName}' +
        			'</div>';
        		}
        	}

        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        cls: 'windowBtnPos',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchAttendancePunchLogReportFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetAttendancePunchLogReportFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});