/**
 * @author Ankur Jaiswal
 */
Ext.define('Academia.view.hrm.report.HRMAttendanceSummaryReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.hrmattendancesummaryreportgrid',
    store: 'hrm.report.HRMAttendanceSummaryReportStore',
    title: getPersonModuleTranslation('HRM_EMPLOYEE_ATTENDANCE_SUMMARY'),
    border: true,
    refreshStoreData: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrm.report.HRMAttendanceSummaryReportStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: ['->', {
        xtype: 'button',
        itemId: 'attendanceRegisterItemId',
        tooltip: getPersonModuleTranslation('HRM_ATTENDANCE_REGISTER'),
        text: getPersonModuleTranslation('HRM_ATTENDANCE_REGISTER'),
    }],
    columns: [{
        header: getCommonTranslation('DATE'),
        dataIndex: 'date',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            if(!isNullOrEmpty(date)){
            	return dateRender(date);
            }
            else{
    			return '';
    		}
        }
    }, {
        header: getPersonModuleTranslation('HRM_TOTAL_EMPLOYEES'),
        dataIndex: 'totalEmployee',
        flex: 1,
        sortable: true,
    }, {
        header: getPersonModuleTranslation('HRM_PRESENTS'),
        dataIndex: 'totalPresent',
        flex: 1,
        sortable: true,
    }, {
        header: getPersonModuleTranslation('HRM_ABSENTS'),
        dataIndex: 'totalAbsent',
        flex: 1
    }, {
        header: getPersonModuleTranslation('HRM_LEAVES'),
        dataIndex: 'totalLeaves',
        flex: 1
    },{
        header: getPersonModuleTranslation('Compensatory Leaves'),
        dataIndex: 'totalCompensatoryLeave',
        flex: 1,
        sortable: false
    },{
        header: getPersonModuleTranslation('LOP'),
        dataIndex: 'totalLOP',
        flex: 1,
        sortable: false
    },{
        header: getPersonModuleTranslation('Others'),
        dataIndex: 'markingTypeStatusCount',
        flex: 1,
        sortable: false
    }, {
        header: getPersonModuleTranslation('HRM_LATE_ARRIVALS'),
        dataIndex: 'totalLateArrivals',
        flex: 1
    }, {
        header: getPersonModuleTranslation('HRM_ATTENDANCE_PERCENT'),
        dataIndex: 'attendancePercentage',
        flex: 1,
        sortable: true,
        renderer : function(attendancePercentage) {
        	if(Number.isInteger(attendancePercentage)) {
        		return (attendancePercentage + '%');	
        	}else {
        		var attendancePercentage =  Ext.util.Format.number(attendancePercentage, '0.00');
            	return (attendancePercentage + '%');
        	}
        }
    }],
});