/**
 * @author Ankur Jaiswal
 */
Ext.define('Academia.view.hrm.timesheet.HRMEmployeeDetailedTimesheetGrid', {
	extend: 'Ext.grid.Panel',
    alias: 'widget.hrmemployeedetailedtimesheetgrid',
    // store: 'hrm.timesheet.HRMEmployeeDetailedTimesheetGrid',
    title: getPersonModuleTranslation('HRM_EMPLOYEE_DETAILED_TIMESHEET'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        getRowClass: function(record, rowIndex, rowParams, store){
            return record.get("isUpdateByUser") ? "clsHRMRowGridBackColor" : "";
        }
    },
    features: [{
        ftype: 'summary',
        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW
    }],
    /*dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
           // store: 'hrm.timesheet.HRMTimesheetGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],*/
    tbar: [],
    columns: [{
        header: getCommonTranslation('DATE'),
        dataIndex: 'attendanceDate',
        flex: 1,
        sortable: false,
        renderer: function(date) {
            return dateRender(date);
        },
        summaryRenderer: function(value, summaryData, dataIndex) {
            return getFeeAndPaymentCommonTranslation('TOTAL');
        },
    }, {
        header: getCommonTranslation('DAY'),
        dataIndex: 'day',
        flex: 1,
        sortable: false,
    }, {
        header: getPersonModuleTranslation('HRM_IN_TIME'),
        dataIndex: 'intime',
        flex: 1,
        sortable: false,
        renderer: function(intime) {
        	 if(!isNullOrEmpty(intime)) {
        		 return timeRender(intime);
             }
            return intime;
        }
    }, {
        header: getPersonModuleTranslation('HRM_OUT_TIME'),
        dataIndex: 'outtime',
        flex: 1,
        sortable: false,
        renderer: function(outtime) {
        	 if(!isNullOrEmpty(outtime)) {
        		 return timeRender(outtime);
             }
            return outtime;
        }
    }, {
        header: getPersonModuleTranslation('HRM_TOTAL_TIME'),
        dataIndex: 'totaltime',
        flex: 1,
        sortable: false,
        renderer: function(totaltime) {
        	if(!isNullOrEmpty(totaltime)) {
        		if(totaltime<0){
        			totaltime = 86400000 + totaltime;
        		}
        		var totalTimeInMinutes = (totaltime / 60000);
        		var minutes = 0 + '' + (totalTimeInMinutes % 60);
        		var hours = 0 + '' + (totalTimeInMinutes - minutes) / 60;
        		totaltime = hours.substr(-2) + ':' + minutes.substr(-2);
        	}
        	return totaltime;
        },
        align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
        summaryType: function(records) {
            var totalHours = 0;
            for (i in records) {
                var hours = records[i].get('totaltime');
                if (!isNullOrEmpty(hours)) {
                	totalHours = totalHours +hours;
                }
            	if(i == (records.length-1) && !isNullOrEmpty(totalHours)) {
            		var totalTimeInMinutes = (totalHours / 60000);
            		/*var minutes = 0 + '' + (totalTimeInMinutes % 60);
            		var hours1 = 0 + '' + (totalTimeInMinutes - minutes) / 60;
            		totalHours = hours1.substr(-2) + ':' + minutes.substr(-2);*/
            		var minutes = (totalTimeInMinutes % 60);
            		var hours = (totalTimeInMinutes - minutes) / 60;
            		if(minutes.lengh<2){
            		 minutes = 0 + '' + (totalTimeInMinutes % 60);
            		}
            		if(hours.length<2){
            		var hours = 0 + '' + (totalTimeInMinutes - minutes) / 60;
            		}
            		if(minutes >= 60) {
            			hours = hours + (minutes /60);
        				minutes = minutes %60;
        			}
            		if(minutes<10){
            			minutes = '0'+minutes;
            		}
                    if(hours<10){
                    	hours = '0'+hours;
                    }
            		totalHours = hours + ':' + minutes;
            		
            		return totalHours;
            	}
            }
            return '';
        },
        summaryRenderer: function(value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
            return value;
        }
         
    }, {
        header: getPersonModuleTranslation('HRM_OVER_TIME'),
        dataIndex: 'overtime',
        flex: 1,
        sortable: false,
        renderer: function(overtime, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(overtime)) {
                if (overtime < 0)
                	overtime = 86400000 + val;
                var totalTimeInMinutes = (overtime / (60*1000));
                var minutes = 0 + '' + (totalTimeInMinutes % 60);
                var hours = 0 + '' + (totalTimeInMinutes - minutes) / 60;
                overtime = hours.substr(-2) + ':' + minutes.substr(-2);
                return overtime;
            }
            return overtime;
         },
        align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
        summaryType: function(records) {
            var totalOverTime = 0;
            for (i in records) {
                var ovetTime = records[i].get('overtime');
                if (!isNullOrEmpty(ovetTime)) {
                	totalOverTime = totalOverTime + ovetTime;
                }
            	if(i == (records.length-1) && !isNullOrEmpty(totalOverTime)) {
            		var totalTimeInMinutes = (totalOverTime / (60*1000));
            		var minutes = (totalTimeInMinutes % 60);
            		var hours = (totalTimeInMinutes - minutes) / 60;
            		
            		if(minutes >= 60) {
            			hours = hours + (minutes /60);
        				minutes = minutes %60;
        			}
            		if(minutes.lengh<2){
               		 minutes = 0 + '' + minutes;
               		}
               		if(hours.length<2){
               		var hours = 0 + '' + hours;
               		}
               		if(minutes<10){
            			minutes = '0'+minutes;
            		}
                    if(hours<10){
                    	hours = '0'+hours;
                    }
            		totalOverTime = hours + ':' + minutes;
            		return totalOverTime;
            	}
            }
            return '';
        },
        summaryRenderer: function(value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
            return value;
        }
    }, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'status',
        flex: 1,
        sortable: false,
        renderer: function(data, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(record) && !isNullOrEmpty(record.raw) && !isNullOrEmpty(record.raw.employeeAttendanceMarkingType) && record.data.status != 'Holiday') {
        		return record.raw.employeeAttendanceMarkingType.value;
        	} else {
        		return record.data.status;
        	}
        }
    }, {
        header: getPersonModuleTranslation('REMARKS'),
        dataIndex: 'remarks',
        flex: 1,
        sortable: false,
    }],
    listeners: {
    	itemmouseenter: function(view, record, item) {
    		if(record.get("isUpdateByUser")){
    			Ext.fly(item).set({'data-qtip': getPersonModuleTranslation('HRM_ATTENDANCE_STATUS_TOOLTIP')});
    		}
    	}
    }
}); 