/**
 * @author Manas.Luktuke
 */
Ext.define('Academia.view.learningtarget.LearningTargetsCoreFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.learningtargetsCorefilter',
    frame: false,
    plugins: "formlabelrequired",
    cls:'customSearchPanel',
    items: [{
    	xtype:'fieldcontainer',
    	layout:'hbox',
    	width:'100%',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items:[{
    		xtype: 'customcombobox',
    		name: 'evaluationType',
    		itemId:'evaluationTypeItemId',
    		store:Ext.create('Academia.store.examCenter.AssignSequence.EvaluationType'), //
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		editable:false,
    		typeAhead:true,
    		allowBlank: false,
    		fieldLabel:getExaminationTranslation('EVALUATION_TYPE'),
    		disabled: false
    	},{
	    	
           xtype : 'customcombobox',
	       name : 'assessmentSchemeAcademicTerm',
	       itemId : 'assessmentSchemeAcademicTermId',
	       fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
	       store :Ext.create('Academia.store.common.AcademicTermStore'),
	       valueField : 'id',
	       displayField : 'value',
	       forceSelection:true,
           allowBlank: false,
	       typeAhead:false,
           disabled:true 
           																																																																				    			
	    		},
             {
    		xtype: 'customcombobox',
    		name:'program',
    		itemId:'programIdItemId',
    		store: Ext.create('Academia.store.program.ProgramCodeOrNameSmartSearch'), //
    		displayField: 'valueCode',
    		valueField: 'id',
    		forceSelection:true,
    		editable:false,
    		typeAhead:true,
    		allowBlank: false,
    		fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
    		disabled: true
    	},{
    		xtype: 'customcombobox',
    		name: 'batchId',
    		itemId:'batchIdItemId',
    		store: Ext.create('Academia.store.examinationcenters.reports.ExaminationResultBatchStore'), //
			valueField: 'id',
			displayField: 'value',
    		forceSelection:true,
    		editable:false,
    		typeAhead:true,
    		allowBlank: false,
    		fieldLabel:getExaminationTranslation('BATCH'),
			disabled: true
    	},{
    		xtype: 'customcombobox',
    		name: 'periodId',
    		itemId: 'periodItemId',
    		store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('PERIOD'),
    		allowBlank:false,
    		visible:false,
            hidden:true
    	},]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{                	
    		xtype: 'customcombobox',
    		name:'courseId',
    		itemId:'courseItemId',
    		store: Ext.create('Academia.store.examinationcenters.evaluation.CoursesForFacultyStore'), //
    		valueField: 'id',
			displayField: 'displayValue',
    		forceSelection:true,
    		editable:false,
    		typeAhead:true,
    		allowBlank: false,
    		fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
    		disabled: true
    	},{
    		xtype: 'customcombobox',
    		name: 'courseVariant',
    		itemId: 'courseVariantItemId',
    		store: Ext.create('Academia.store.attendance.VariantMappedToSpecialGrade'), //
    		valueField: 'id',
    		displayField: 'value',
    		forceSelection: true,
    		editable:false,
    		typeAhead: true,
    		allowBlank: false,
    		fieldLabel: getExaminationTranslation('COURSE_VARIANT'),
    		disabled: true
    	},{
			xtype: 'customcombobox',
			name:'evalautionPlan',
			itemId:'evalautionPlanItemId',
			store:Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.EvalPlanTemplateMarksentry'), //
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			allowBlank:false,
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			disabled:true
		},{
            xtype: 'groupingcombobox',
            name: 'evalPlanLevelId',
            itemId:'evalPlanLevelItemId',
            labelAlign:'top',
            queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            store: Ext.create('Academia.store.examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
           // valueField: 'id' ,
            minChar : 3,
            disabled:true,
            allowBlank: false
        }]
    },  {
    	xtype: 'fieldcontainer',
    	width: '100%',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SEARCH'),
    		itemId: 'learningTargetSearchButtonId',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	},{
    		xtype: 'button',
    		text: getCommonTranslation('RESET'),
    		itemId: 'clearSearch',
    		buttonAlign: 'right',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE,
    		listeners: {
    			click: function(button, eOpts) {
    				this.up('form').getForm().reset();
    			}
    		}
    	}]
    }]
});
