/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.AddLeaveTypeForm', {
	extend: 'Ext.form.FormPanel',
	alias : 'widget.addleavetypeform',
    modal: true,
    autoScroll:false,
    frame:true,
    title:getCommonTranslation('CREATE_LEAVEL_TYPE'),
//	plain: true,
    items : [{
    	xtype:'form',
    	plugins:"formlabelrequired",
    	items : [{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
    			xtype: 'hidden',
    			itemId:'idItemId',
    			name: 'id'
    		}, {
    			xtype: 'textfield',
    			name: 'levelCodeName',
    			fieldLabel:getCommonTranslation('LEAVE_CODE'),
    			allowBlank:false,
    			vtype: 'spaceAndSpecialCharactersAsInput'
    		},{
    			xtype: 'textfield',
    			name: 'levelTypeName',
    			fieldLabel: getCommonTranslation('LEAVE_TYPE'),
    			allowBlank:false,
    			vtype: 'spaceAndSpecialCharactersAsInput'
    		},{
            	xtype: 'customcombobox',
                name: 'EligibilityEnum',
                itemId:'EligibilityEnumItemId',
                store:'leavemanagement.EligibilityEnumStore',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                editable:false,
                allowBlank:false,
                typeAhead:true,
                fieldLabel:getCommonTranslation('ELIGIBILITY_BASED_ON'),
            }]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('ALLOWED_IN_NOTICE'),
				itemId: 'allowInNoticeGrpId',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherAllowInNotice', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherAllowInNotice', 
					inputValue: false,
					checked:true
				}]
			},{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('EXTENDS_NOTICE'),
				itemId: 'extendsNoticeGrpId',
				name:'extendsNoticeGrp',
				disabled:true,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherExtendsNotice', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherExtendsNotice', 
					inputValue: false,
					checked:true
				}]
			},{
                xtype      : 'radiogroup',
                fieldLabel : getCommonTranslation('ALLOW_BACKDATED_LEAVE'),
                itemId: 'allowBackdateId',
                name:'allowBackdate',
                defaults: {
                        flex: 1
                },
                layout: 'hbox',
                items:[{
                        boxLabel: getCommonTranslation('YES'),
                        name: 'allowBackdateleave',
                        inputValue: true,
                        checked:true
                },{
                        boxLabel: getCommonTranslation('NO'),
                        name: 'allowBackdateleave',
                        inputValue: false
                        
                }]
        },{
				xtype: 'numberfield',
				name: 'validWithinDays',
				itemId: 'validWithinDaysItemId',
				hidden:true,
				fieldLabel: getCommonTranslation('VALID_WITHIN_DAYS'),
				editable:false,
                allowBlank:false,
                minValue : 1,
				maxValue:1000,
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('PAYRATE_DEDUCTION'),
				itemId: 'deductionGrpId',
				name:'deductionGrp',
//				hidden:true,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherDeductionGrp', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherDeductionGrp',
					inputValue: false,
					checked:true
				}]
			},{
				xtype: 'numberfield',
				name: 'deductionPercent',
				disabled:true,
				fieldLabel: getCommonTranslation('PERCENT_DEDUCTION'),
				minValue : 0,
				maxValue:100,
				allowDecimal:true
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype: 'datefield',
				name: 'validFrom',
				itemId: 'validFromItemId',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'validTillItemId',
//				value:new Date(),
				editable:false,
				fieldLabel:getCommonTranslation('VALID_FROM'),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype: 'datefield',
				name: 'validTill',
				itemId:'validTillItemId',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'validFromItemId',
				editable:false,
				fieldLabel:getAdmissionTranslation('VALID_TILL')
			},{
				xtype:'statusCombo',
				name:'status',
				editable:false,
				value:true
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 460,
    			labelAlign: 'top'
    		},
    		items:[{
   			 xtype: 'textarea',
		     name:'description',
		     width: 460,
		     maxLength : 250,
		     fieldLabel: getExaminationTranslation('Description')
		}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('DOCUMENT_REQUIRED'),
				itemId: 'reqDocsGrpId',
				name:'reqDocsGrp',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherReqDocsGrp', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherReqDocsGrp', 
					inputValue: false,
					checked:true
				}]
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 460,
    			labelAlign: 'top'
    		},
    		items:[{
    			xtype: 'multiselectcombofield',
    			name:'documentId',
    			itemId:'documentItemId',
    			disabled:true,
    			allowBlank:false,
    			store:'leavemanagement.DocsRequiredStore',
    			valueField : 'id',
    			displayField : 'value',
    			enableKeyEvents  : 'true',
				forceSelection:true,
				typeAhead:false,
				hideTrigger:false,
				cls:'multiBrandCampusCls',
    			listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
    			}
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		cls:'windowBtnPos',
    		items:[{
    			xtype: 'button',
    			itemId:'submitBtn',
    			text: getCommonTranslation('SUBMIT'),
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    			formBind:true
    		},{
	            xtype: 'button',
	            text: getCommonTranslation('RESET'),
	            itemId:'resetBtn',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
    	}]
    }]
	});