Ext.define('Academia.view.lecturerCostingDefinition.LCDEditCourseWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.lcdeditcoursewindow',

    modal: true,
    resizable: false,
    autoScroll: false,
    title: getCommonTranslation('COST_DETAILS'),
    height: 500,
    width: 1150,
    frame: true,
    layout: 'vbox',
    cls: 'progressionPanelDetailsCls',
    closeAction: 'destroy',

    initComponent: function () {
        Ext.apply(this, {
            items: [
             //   this.createStaticFieldPanel(),
               // this.createLecturerCostingGrid()
                {
            		xtype: 'lecturercostingcourseinnerdetails',
            	},
                {
            		xtype: 'lecturercostingcourseinnergrid',
            	}
            ]
        });
        this.callParent(arguments);
    }
    /* ,
    createStaticFieldPanel: function () {
        return {
            xtype: 'panel',
            width: '100%',
            height: 50,
            alias: 'widget.lcdcourseeditpanelview',
            plugins: 'formlabelrequired',
            border: false,
            layout: { type: 'vbox' },
            defaults: {
                labelAlign: 'top',
                width: 226,
                margin: 0
            },
            items: [{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: { type: 'hbox' },
                defaults: {
                    width: 226,
                    labelAlign: 'top'
                },
                items: [
                    this.createDisplayField('lecturer', getCommonTranslation('LECTURER'),226),
                    this.createDisplayField('courseVariantId', getCourseTxCommonTranslation('COURSE_VARIANT'),660)
                ]
            }]
        };
    },

    createDisplayField: function (itemId, label, width) {
        return {
            xtype: 'displayfield',
            name: itemId,
            itemId: itemId,
            fieldLabel: label,
            width:width
        };
    },

    createLecturerCostingGrid: function () {
        return {
            xtype: 'grid',
            title: getCommonTranslation('LECTURER_COSTING_LIST'),
            itemId: 'lcdCourseGridId',
            border: true,
            width: 1060,
            minHeight: 100,
            maxHeight: 300,
            viewConfig: { stripeRows: CONSTANTS.STRIPEROWS },
            autoScroll: true,
            scrollable: {
                x: false, // Disable horizontal scrolling
                y: true   // Enable vertical scrolling
            },
            store: Ext.create('Academia.store.lecturercostingdefinition.LCDEditCourseStore'),
            tbar: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'addCourseCostingBtn'
            },
            {
                xtype: 'button',
                itemId: 'btnDelete',
                cls: 'CustomToolbarBtnReject',
                tooltip: getCommonTranslation('DELETE'),
                glyph: ICONGLYPH.DELETEGLYPH
            }
            ],
            columns: this.getGridColumns(),
            plugins: [{ ptype: 'cellediting', clicksToEdit: 1,
            	listeners: {
                    beforeedit: function (editor, context) {
                        if (context.field === 'fromDate' || context.field === 'tillDate') {
                            var value = context.record.get(context.field);
                            if (value) {
                                var dateField = context.column.getEditor();
                                context.record.suspendEvents();
                                setTimeout(function(){
                                    dateField.setValue(new Date(value)); // Set the date value in the editor
                                },500);
                                context.record.resumeEvents();
                            }
                        }
                    }
                }}]
        };
    },

     getGridColumns: function () {
        return [
            this.createFromDateColumn('fromDate', getCommonTranslation('FROM_DATE')),
            this.createTillDateColumn('tillDate', getCommonTranslation('TILL_DATE')),
            this.createComboColumn('currencyId', getFeeAndPaymentCommonTranslation('CURRENCY'), 'feeandpayment.AccountingConfigCurrencyStore'),
            this.createNumberColumn('cost', getCommonTranslation('COST')),
            this.createNumberColumn('maxDailyHours', getCommonTranslation('MAX_DAILY_HOURS')),
            this.createTextAreaColumn('comments', getCommonTranslation('COMMENTS')),
            this.createTextColumn('updatedBy', getProgramandcourseTranslation('UPDATED_BY')),
            this.createRendererColumn('updatedDate', getProgramandcourseTranslation('UPDATED_DATE'), dateRender)
        ];
    },
    
    createFromDateColumn: function (dataIndex, header) {
        return {
            header: header,
            dataIndex: dataIndex,
            sortable: true,
            flex: 0.2,
            editor: {
                xtype: 'datefield',
                name: dataIndex,
                itemId: dataIndex,
                editable: false, // Disable manual editing
                format: 'd-m-Y', // Display format
                allowBlank: false, // Ensure value is required
                listeners: {
                    select: function (field, value) {
                        var grid = field.up('grid'); // Get reference to the grid
                        var record = grid.getSelectionModel().getSelection()[0]; // Get selected record
                        var tillDate = grid.columns[1].getEditor(); // Get the editor for the 'tillDate' column
                        
                        grid.suspendLayouts();
                        // Set the selected 'fromDate' in the record
                        record.set('fromDate', value.getTime());
                        
                        // Reset and restrict 'tillDate'
                        record.set('tillDate', null); // Clear tillDate
                        tillDate.setMinValue(value); // Set minValue for tillDate
                        grid.resumeLayouts();
                    }
                }
            },
            renderer: this.dateRenderer
        };
    },


    createTillDateColumn: function (dataIndex, header) {
        return {
            header: header,
            dataIndex: dataIndex,
            sortable: true,
            flex: 0.2,
            editor: {
                xtype: 'datefield',
                name: dataIndex,
                itemId: dataIndex,
                listeners: { render: dateFormatRender }
            },
            renderer: this.dateRenderer
        };
    },

    dateRenderer: function (val,rec) {
        var dateVal = dateRender(val);
        if (dateVal === 'NaN-NaN-0NaN') return val;

        if (!isNullOrEmpty(val)) {
            var date = moment(new Date(val), 'DD/MM/YYYY').format('DD-MM-Y');
            if (date === 'Invalid date') date = moment(new Date(val), 'MM/DD/YYYY').format('DD-MM-Y');
            return date;
        }
        else{
    		rec.tdCls = 'gridInputCustomStyle';
            return getExaminationTranslation('CLICK_TO_ENTER');
		}
    },

    createComboColumn: function (dataIndex, header, store) {
        return {
            header: header,
            dataIndex: dataIndex,
            sortable: true,
            flex: 0.2,
            renderer:function(value, meta, record) {
				if(isNullOrEmpty(value)){
					meta.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return record.data.currency;
				}
			},
            editor: {
                xtype: 'customcombobox',
                name: dataIndex,
                itemId: dataIndex,
                store: Ext.create('Academia.store.feeandpayment.AccountingConfigCurrencyStore',{
		    		autoLoad: true
		    	}),
                valueField: 'id',
                displayField: 'name',
                forceSelection: true,
                editable: false,
	            typeAhead: false,
	            hideTrigger: false,
                listeners : {
                	change:function(field, newValue, oldValue){ 
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						grid.suspendLayouts();
						record.set('currencyId',newValue);
						record.set('currency',field.getDisplayValue());
				        grid.resumeLayouts();
                	}
                }
            },
        };
    },

    createNumberColumn: function (dataIndex, header) {
        return {
            header: header,
            dataIndex: dataIndex,
            sortable: true,
            flex: 0.2,
            editor: {
                xtype: 'numberfield',
                name: dataIndex,
                itemId: dataIndex,
                mouseWheelEnabled :false,
				hideTrigger :true,
				allowDecimals:true,
				allowExponential:false,
				validateOnBlur: true,
				decimalPrecision: 2,
				minValue: 0,
				maxValue:999999,
				validator: function(value) {
			        if (value === '' || value === null) {
			            return true;
			        }
			        var parts = value.toString().split('.');
			        if (parts.length === 2 && parts[1].length > 2) {
			            return 'Only up to two decimal places are allowed.';
			        }
			        return true;
			    }
            }
        };
    },

    createTextAreaColumn: function (dataIndex, header) {
        return {
            header: header,
            dataIndex: dataIndex,
            sortable: true,
            flex: 0.2,
            editor: {
                xtype: 'textarea',
                name: dataIndex,
                itemId: dataIndex,
                height: 50,
                maxLength: 512,
                allowBlank: true
            },
        renderer: function(value) {
     
            if (value && value.length > 100) { 
                return '<div style="height: 3em; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;" data-qtip="' + value + '">' + value.substring(0, 100) + '...</div>';
            }
            return value;
        },
        tooltip: {
            text: '{' + dataIndex + '}' // Show the full content in the tooltip
        }
        };
    },

    createTextColumn: function (dataIndex, header) {
        return {
            header: header,
            dataIndex: dataIndex,
            sortable: true,
            flex: 0.2
        };
    },

    createRendererColumn: function (dataIndex, header, rendererFn) {
        return {
            header: header,
            dataIndex: dataIndex,
            sortable: true,
            flex: 0.2,
            renderer: rendererFn
        };
    }*/
});
