/**
 * Forgot Password Form
 * @author Prathamesh.Sheth
 */
Ext.define('Academia.view.login.ResetPasswordForm', {
	extend : 'Ext.form.Panel',
	alias : 'widget.resetpasswordform',
	bodyStyle: { background:'#f0f0f0'},
	plugins : "formlabelrequired",
	margin:0,            	 
	autoScroll:true,       
	layout : {
		align : 'center',
		pack : 'start', 
		type : 'vbox'
	},
	items : [{
	xtype : 'fieldset',
	cls:'resetPasswordFormfieldset',
	style: { background:'#ffffff', border:'1px solid #D1D1D1 !important', display: 'table'   , padding: '0px !important',
		'width' : '100%'},
	width : 400,
	height: 'auto',
	autoScroll:true,
	items : [{
		xtype:'fieldcontainer',
		flex:1,
		itemId:'clientLogoContainer',
	    style:{'text-align': 'center','width':'100% !important','border-bottom': '1px solid #D1D1D1 !important'},
		items:[{
			xtype:'image',
			flex:0.1,
			align:'center',
			margin:'5px 0px 5px 0px',
			itemId:'clientLogo',
			height:100
		}]
	},{
        xtype: 'container',
        layout: 'hbox',
        height: 'auto',
        style :{
        	'padding': '10px 10px 10px 0px !important',
            'border-bottom': '1px solid #D1D1D1 !important',
        	'margin-bottom:':'10px !important',
        	'width':'100%'
        },
        items: [{
            xtype: 'displayfield',
            itemId: 'userCode',
            name: 'userCode',
            flex: 1,
            labelAlign: 'top',
            padding:'0 3 0 3',
            fieldLabel: getPersonModuleTranslation('USER_NAME'),
            style :{
            	'text-align':'center',
            	'word-wrap':'break-word'
            }
        }, {
            xtype: 'displayfield',
            itemId: 'userName',
            name: 'userName',
            flex: 1,
            labelAlign: 'top',
            padding:'0 2 0 5',
            fieldLabel: getPersonModuleTranslation('NAME'),
            style :{
            	'text-align':'center',
            	'word-wrap':'break-word'
            }
        }, {
            xtype: 'displayfield',
            itemId: 'userEmailId',
            name: 'userEmailId',
            flex: 1,
            labelAlign: 'top',
            fieldLabel: getPersonModuleTranslation('EMAIL'),
            style :{
            	'text-align':'center',
            	'word-wrap':'break-word'
            }
        }]
    },{
    	xtype:'container',
    	style: { background:'#ffffff', padding:'10px 70px 0px 70px !important', display: 'table'},
    	defaults:{
    		labelAlign: 'top',
    		width: 260
    	},
    	items:[{
		    xtype : 'textfield',
		    allowBlank: false,
		    inputType : 'password',
            labelAlign: 'top',
		    name: 'currentPassword',
		    fieldLabel : getCommonTranslation('CURRENT_PASSWORD'),
		},{
		    xtype : 'textfield',
		    allowBlank: false,
		    inputType : 'password',
            labelAlign: 'top',
	 	    itemId: 'newPassword',
		    name: 'newPassword',
		    fieldLabel : getCommonTranslation('NEW_PASSWORD'),
	  	    invalidCls:Ext.baseCSSPrefix + 'form-invalid',
	  	    msgTarget:'under'
		}, {
		    xtype : 'textfield',
		    allowBlank: false,
		    inputType : 'password',
		    name: 'confirmedPassword',
            labelAlign: 'top',
		    fieldLabel : getCommonTranslation('CONFIRM_PASSWORD'),
		    vtype: 'passwordAndPolicyMatch',
		    initialPassField: 'newPassword' // id of the initial password field
		},{
	    	xtype:'fieldcontainer',
	    	//width:'100%',    	
	    	//cls:'windowBtnPos',    	
	        items: [{
				xtype: 'button',
				formBind: true,
				text : getCommonTranslation('SUBMIT'),
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE    			
	        	},{
					xtype: 'button',				
					text : getCommonTranslation('CANCEL'),
					itemId: 'cancelBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE				
	        	}]
			}, {
				xtype : 'fieldset',
				collapsible : true,
				collapsed : true,
				title : getCommonTranslation('PASSWORD_POLICY'),
				titleCollapse : true,
				defaults : {
					labelAlign : 'top',
					width : 260
				},
				style : {
					marginTop : '40px!important',
				},
				items : [ {
					xtype : 'dataview',
					itemId : 'passwordPolicyTemplate',
					tpl : new Ext.XTemplate('<tpl></tpl>')
				}, {
					xtype : 'displayfield',
					height : 30
				} ]
			},]
    }]
    },{
	    xtype : 'displayfield',
	    height:30
	 }]
});
