/**
 * Deepak.Nigam
 */
Ext.define('Academia.view.manageDetention.DetentionCriteriaWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.detentioncriteriawin',
	modal: true,
	autoScroll:true,
	title: getExaminationTranslation('ADD_DETENTION_CRITERIA'),
	maxHeight:500,
	width: 530,
	height:350,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getExaminationTranslation('DETENTION_CRITERIA_NAME'),
				name: 'detentionCriteriaName',
				itemId: 'detentionNameItemId',
				allowBlank:false
			}]
		},{
			xtype:'displayfield',
			value:'<b class="menu-title">'+getExaminationTranslation('ATTENDANCE_PERCENTAGE_RANGE')+'</b>',
			style: {
				textDecoration: "underline"
			}
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'numberfield',
				fieldLabel: getExaminationTranslation('FROM'),
				name: 'percentagefrom',
				itemId: 'percentagefromItemId',
				minValue : 0,
				maxValue :99,
				value:0,
				allowBlank:false,
				validator : function(val) {
              		 var maxValuefield = this.nextSibling();
              		 var maxValue = maxValuefield.getValue();
              		 if (maxValue != null) {
              			 if (val < maxValue) {
              				 maxValuefield
              				 .clearInvalid();
              				 return true;
              			 } else {
              				 return getCommonTranslation('LESS_THAN_MAX_VALUE');
              			 }
              		 } else {
              			 return true;
              		 }
				}
			},{
				xtype: 'numberfield',
				fieldLabel: getExaminationTranslation('TO'),
				name: 'percentageTo',
				itemId: 'percentageToItemId',
				minValue : 1,
				maxValue :100,
				allowBlank:false,
				 validator : function(val) {
        	   		 var minValueField =this.previousSibling();
        	   		 var minValue = minValueField
        	   		 .getValue();
        	   		 if (minValue != null) {
        	   			 if (val > minValue) {
        	   				 minValueField
        	   				 .clearInvalid();
        	   				 return true;
        	   			 } else {
        	   				 return getCommonTranslation('MORE_THAN_MIN_VALUE');
        	   			 }
        	   		 } else {
        	   			 return true;
        	   		 }
        	   	 }
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'datefield',
				fieldLabel: getExaminationTranslation('ATTENDANCE_PERCENTAGE_AS_ON_DATE'),
				name: 'attendancePercentageAsOnDate',
				itemId : 'attendancePercentageAsOnDateId',
				vtype: 'daterange',
				allowBlank:false,
				//--submitFormat:CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'detentionGrade',
				itemId: 'detentionGrade',
				fieldLabel: getExaminationTranslation('DETENTION_GRADE'),
				store:'manageDetention.DetentionGradeStore',
				valueField: 'valueField',
				displayField: 'displayValue',
				queryParam:'grade',
				minChars:1,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:false,
				//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SUBMIT'),
				itemId: 'submitButtonId',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]
});