/**
 * @Author Bhanu PS
 */
Ext.define('Academia.view.manageDetention.EventMappingFilter', { 
	extend: 'Ext.form.Panel',
	alias : 'widget.eventmappingfilter',
	autoScroll: false,
	cls:'customSearchPanel',
    frame: false,
    standardSubmit: false,
    plugins:"formlabelrequired",
    items: [{
    	xtype:'form',
    	items:[{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign: 'top',
    		},
    		items:[{
    			xtype: 'customcombobox',
    			name:'programId',
    			itemId:'programItemId',
    			store:'common.ProgramStore',
    			fieldLabel:getExaminationTranslation('PROGRAM'),
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'programName',
    			minChars:3,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			allowBlank:false,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
	  				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
    		},{
    			xtype: 'customcombobox',
    			name: 'batchId',
    			itemId:'batchItemId',
    			fieldLabel: getExaminationTranslation('BATCH'),
    			store: 'enquiry.BatchAndStartEndDateStore',
    			displayField: 'value',
    			valueField: 'id',
    			typeAhead: true,
    			disabled : true,
    			forceSelection: true,
    			allowBlank:false,
    			listConfig: {
	  				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					}
    			}
    		},{
        		xtype: 'customcombobox',
        		name: 'periodId',
        		itemId: 'periodItemId',
        	    store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
        		displayField:'value',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
        		fieldLabel:getExaminationTranslation('PERIOD'),
        		disabled:true,
        		allowBlank:false,
        		listConfig: {
	  				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					}
        		}
        	}]
    	},{
            xtype: 'fieldcontainer',
            width: 'auto',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'quickSearchId',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind:true
            },{
            	xtype: 'button',
    			itemId: 'resetBtn',
    			text: getCommonTranslation('RESET'),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});
