/**
 * @author Ramkrishna Yadav
 * 
 */
Ext.define('Academia.view.mangeElections.mangeElections.ElectionFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.electionfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype : 'radiogroup',
		itemId: 'committeeRadioGrp',
		name:'manageCommittee',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
    		margin:'0 5 0 5'
		},
		
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'customcombobox',
			width: 226,
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			typeAhead : true,
			editable : false
		},{
			xtype: 'customcombobox',
			name: 'electioncCodeName',
			itemId:'electioncCodeName',
		    store:'election.election.ElectionCodeNameStore',
			displayField:'valueCode',
			valueField:'id',
			queryParam:'codeOrName',
			typeAhead:false,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			},
			fieldLabel:getCommonTranslation("ELECTION_CODE_NAME")
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("ELECTION_TYPE"),
			name: 'electionType',
			itemId:'electionType',
			editable: true,
			store: 'election.election.ElectionTypeStore',
			displayField: 'value',
			valueField: 'id',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'codeOrName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			width:226,
			labelAlign: 'top'
		},
		items : [{
    		xtype: 'datefield',
    		name: 'startDate',
    		itemId:'startDate',
    		allowBlank:true,
    		//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		vtype: 'daterange',
			endDateField: 'endDate',
			editable:false,
    		fieldLabel:getCommonTranslation('VOTING_START_DATE')
    	},{
    		xtype: 'datefield',
    		name: 'endDate',
    		itemId:'endDate',
    		allowBlank:true,
    		vtype: 'daterange',
			startDateField: 'startDate',
			editable:false,
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		fieldLabel:getCommonTranslation('VOTING_END_DATE')
    	},{
			xtype: 'customcombobox',
			name: 'status',
			itemId:'statusItemId',
			store:'common.StatusComboStore',
			displayField:'name',
			valueField:'id',
			value:'ACTIVE',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getCommonTranslation('STATUS'),
			/*listeners: {
				render: function(object) {
					object.getStore().load({
						callback:function(record) {
							object.setValue(record[0].data.id);
						}
					});
				}
			}*/
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation("SEARCH"),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
