/**
 * @author Amit Gupta
 */
Ext.define('Academia.view.mobile.mobilesyncreport.MobileSyncGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.mobilesyncgrid',
	store: 'mobile.mobilesyncreport.MobileSyncGridStore',
	title: getCommonTranslation('MOBILE_SYNC_REPORT'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'mobile.mobilesyncreport.MobileSyncGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		this.callParent(arguments);
	},
	columns: [{  
	    header:  getCommonTranslation('ACTION_FOR'),
	    dataIndex: 'actionFor',
	    flex:.7,
	    sortable:true
	  },{
	    header:  getCommonTranslation('ACTION'),
	    dataIndex: 'action',
	    flex:.6,
	    sortable:true
	  },{
	    header:  getCommonTranslation('DESCRIPTION'),
	    dataIndex: 'description',
	    flex:1,
	    sortable:true
	  },{
		  header:  getCommonTranslation('OTHER_DETAILS1'),
		  dataIndex: 'info1',
		  flex:1,
		  sortable:true
	  },{
		  header:  getCommonTranslation('OTHER_DETAILS2'),
		  dataIndex: 'info2',
		  flex:1,
		  sortable:true
	  },{
		  header:  getCommonTranslation('OTHER_DETAILS3'),
		  dataIndex: 'info3',
		  flex:1,
		  sortable:true
	  },{
		  header:  getCommonTranslation('STATUS'),
		  dataIndex: 'status',
		  flex:1,
		  sortable:true
	  },{
	    header:  getCommonTranslation('ERROR'),
	    dataIndex: 'errorMessage',
	    flex:2,
	    sortable:true
	  }]
});

