/**
 * 
 * This component is used for to show Address Details Dialog Box 
 */

Ext.define('Academia.view.organization.managementaccounting.ManagementAccountFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.managementAccountFormWindow',
    modal: true,
    frame: true,
    title: getCommonTranslation('MANAGEMENT_ACCOUNT_GRP_DETAILS'),
    plugins : 'formlabelrequired',
    items: [{
        xtype: 'form',
        autoScroll: true,
        defaults: {
            lableAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'hidden',
            name: 'id'
        },{
            xtype: 'hidden',
            name: 'version'
        },{
            xtype: 'hidden',
            name: 'organizationId'
        },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            labelAlign: 'top',
	            width: 226
	        },
	        items: [{
	            xtype: 'textfield',
	            fieldLabel: getCommonTranslation('SHORTCODE'),
	            name: 'shortCode',
	            itemId:'shortCode',
	            allowBlank:false,
	            enforceMaxLength:true,
	            maxLength:15
	        }, {
	            xtype: 'textfield',
	            fieldLabel: getCommonTranslation('GROUP_NAME'),
	            name: 'unitName',
	            allowBlank:false
	        }]

	    },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	        	labelAlign: 'top',
	            width: 226
	        },
	        items: [{
	            xtype: 'customcombobox',
	            fieldLabel: getCommonTranslation('GROUP_TYPE'),
	            name: 'organizationUnitTypeId',
	            store: 'organization.OrganizationUnitType',
	            displayField: 'typeName',
	            valueField: 'id',
	            queryMode: 'remote',
	            editable: false,
	            allowBlank:false
	        }, {
	            xtype: 'statusCombo',
	            fieldLabel: getCommonTranslation('STATUS'),
	            name: 'status',
	            editable: false,
	            allowBlank:false
	        }]

	    }, {
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        items: [{
	            xtype: 'textarea',
	            labelAlign: 'top',
	            fieldLabel: getCommonTranslation('GROUP_NOTE'),
	            name: 'note',
	            width:462
	        }]
	    },  {
        	xtype:'fieldcontainer',
        	width:'100%',
        	cls:'windowBtnPos',
            items: [{
                xtype: 'button',
                action: 'Submit',
                formBind : true,
                text: getCommonTranslation('SAVE'),
                itemId: 'formSubmitButtonId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                action: 'Cancel',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});