/**
 * @author trupti.paoneker
 * 
 * This component is used for to show window with new community master details. 
 */
Ext.define('Academia.view.othermasters.communitymaster.CommunityMasterFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.communitymasterformwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('COMMUNITY_MASTER_DETAILS'),
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'communityMasterForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'communityMaster_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'vbox'
            },
            items: [{
                xtype: 'nestedJsonCombo',
                fieldLabel: getCommonTranslation('COMMUNITY'),
                name: 'community',
                labelAlign: 'top',
                itemId: 'community',
                store: 'Academia.store.othermasters.communitymaster.CommunityComboStore',
                displayField: 'value',
                valueField: 'id',
                queryMode: 'remote',
                allowBlank:false
            }, {
                xtype: 'fieldcontainer',
                items : [{
                xtype: 'acadlocprogbatchseattypecomponent',
                style :{
                	marginLeft : '0px'
                }
            }]
        }]}, {
            xtype: 'fieldcontainer',
            width: '100%',
            style:{
            	  marginTop: '-16px',
            	  marginLeft: '-2px'
            },
            items: [{
                xtype: 'button',
                itemId: 'btnSaveCommunityMasterForm',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelCommunityMasterForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});